/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.api.scheduler;

import com.google.common.base.Suppliers;
import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.platform.Platform;
import com.jodexindustries.donatecase.api.scheduler.Scheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class DCFuture<T>
extends CompletableFuture<T> {
    private static final Supplier<Platform> PLATFORM = Suppliers.memoize(() -> DCAPI.getInstance().getPlatform());
    private static final Supplier<Scheduler> SCHEDULER = Suppliers.memoize(() -> PLATFORM.get().getScheduler());

    public static <U> DCFuture<U> completedFuture(U value) {
        DCFuture<U> future = new DCFuture<U>();
        future.complete(value);
        return future;
    }

    @Override
    @NotNull
    public <U> DCFuture<U> thenComposeAsync(@NotNull Function<? super T, ? extends CompletionStage<U>> fn) {
        DCFuture future = new DCFuture();
        ((CompletableFuture)super.thenComposeAsync((Function)fn)).whenComplete((T res, U ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(res);
            }
        });
        return future;
    }

    public static <U> DCFuture<U> supplyAsync(Supplier<U> supplier) {
        DCFuture future = new DCFuture();
        CompletableFuture.supplyAsync(supplier).whenComplete((T result, U error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
            } else {
                future.complete(result);
            }
        });
        return future;
    }

    public static <U> DCFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        DCFuture future = new DCFuture();
        CompletableFuture.supplyAsync(supplier, executor).whenComplete((T result, U error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
            } else {
                future.complete(result);
            }
        });
        return future;
    }

    public DCFuture<T> thenAcceptSync(Consumer<? super T> action) {
        super.thenAccept((T result) -> SCHEDULER.get().run((Addon)PLATFORM.get(), () -> action.accept(result)));
        return this;
    }

    public DCFuture<T> thenAcceptSync(Consumer<? super T> action, long delay) {
        super.thenAccept((T result) -> SCHEDULER.get().run((Addon)PLATFORM.get(), () -> action.accept(result), delay));
        return this;
    }

    public <U> DCFuture<U> thenApplySync(Function<? super T, ? extends U> fn) {
        DCFuture next = new DCFuture();
        super.thenAccept((T result) -> SCHEDULER.get().run((Addon)PLATFORM.get(), () -> next.complete(fn.apply(result))));
        return next;
    }

    public DCFuture<T> thenRunSync(Runnable action) {
        super.thenAccept((T result) -> SCHEDULER.get().run((Addon)PLATFORM.get(), action));
        return this;
    }

    public DCFuture<T> whenCompleteSync(BiConsumer<? super T, ? super Throwable> action) {
        super.whenComplete((T res, U ex) -> SCHEDULER.get().run((Addon)PLATFORM.get(), () -> action.accept((Object)res, (Throwable)ex)));
        return this;
    }
}

