/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.command;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommand;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommandExecutor;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommandTabCompleter;
import com.jodexindustries.donatecase.api.platform.DCCommandSender;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.platform.BackendPlatform;
import com.jodexindustries.donatecase.common.tools.LocalPlaceholder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class GlobalCommand
implements SubCommandExecutor,
SubCommandTabCompleter {
    private final BackendPlatform backend;

    public GlobalCommand(BackendPlatform backend) {
        this.backend = backend;
    }

    @Override
    public boolean execute(@NotNull DCCommandSender sender, @NotNull String label, String @NotNull [] args) {
        if (args.length == 0) {
            this.sendHelp(sender, label);
        } else {
            String subCommandName = args[0];
            SubCommand subCommand = this.backend.getAPI().getSubCommandManager().get(subCommandName);
            if (subCommand == null) {
                this.sendHelp(sender, label);
                return false;
            }
            String permission = subCommand.permission();
            if (permission == null || sender.hasPermission(permission)) {
                try {
                    if (!subCommand.execute(sender, label, Arrays.copyOfRange(args, 1, args.length))) {
                        this.sendHelp(sender, label);
                    }
                }
                catch (Exception e) {
                    this.backend.getLogger().log(Level.WARNING, "Error with executing subcommand: " + subCommandName, e);
                }
            } else {
                sender.sendMessage(DCTools.prefix(this.backend.getAPI().getConfigManager().getMessages().getString("no-permission")));
            }
        }
        return true;
    }

    public void sendHelp(DCCommandSender sender, String label) {
        Map<String, List<Map<String, SubCommand>>> addonsMap;
        if (!sender.hasPermission("donatecase.player")) {
            sender.sendMessage(DCTools.prefix(this.backend.getAPI().getConfigManager().getMessages().getString("no-permission")));
            return;
        }
        sender.sendMessage(DCTools.rc("&aDonateCase &7v&6" + this.backend.getVersion() + " &7(&eAPI &7v&6" + "2.1.0.5" + "&7) by &c_Jodex__"));
        if (!sender.hasPermission("donatecase.mod")) {
            this.sendHelpMessages(sender, "help-player", label);
        } else {
            this.sendHelpMessages(sender, "help", label);
        }
        if (this.backend.getAPI().getConfigManager().getConfig().addonsHelp() && DCTools.isHasCommandForSender(sender, addonsMap = this.buildAddonsMap())) {
            this.sendAddonHelpMessages(sender, addonsMap);
        }
    }

    private void sendHelpMessages(DCCommandSender sender, String path, String label) {
        for (String string : this.backend.getAPI().getConfigManager().getMessages().getStringList(path)) {
            sender.sendMessage(DCTools.rc(DCTools.rt(string, LocalPlaceholder.of("%cmd%", label))));
        }
    }

    private Map<String, List<Map<String, SubCommand>>> buildAddonsMap() {
        HashMap<String, List<Map<String, SubCommand>>> addonsMap = new HashMap<String, List<Map<String, SubCommand>>>();
        this.backend.getAPI().getSubCommandManager().getMap().forEach((subCommandName, subCommand) -> {
            Addon addon = subCommand.addon();
            addonsMap.computeIfAbsent(addon.getName(), k -> new ArrayList()).add(Collections.singletonMap(subCommandName, subCommand));
        });
        return addonsMap;
    }

    private void sendAddonHelpMessages(DCCommandSender sender, Map<String, List<Map<String, SubCommand>>> addonsMap) {
        addonsMap.forEach((addon, commands) -> {
            if (!addon.equalsIgnoreCase("DonateCase") && DCTools.isHasCommandForSender(sender, commands)) {
                String addonNameFormat = this.backend.getAPI().getConfigManager().getMessages().getString("help-addons", "format", "name");
                if (!addonNameFormat.isEmpty()) {
                    sender.sendMessage(DCTools.rc(DCTools.rt(addonNameFormat, LocalPlaceholder.of("%addon%", addon))));
                }
                commands.forEach(command -> command.forEach((commandName, subCommand) -> {
                    String description = subCommand.description();
                    description = description != null ? DCTools.rt(this.backend.getAPI().getConfigManager().getMessages().getString("help-addons", "format", "description"), LocalPlaceholder.of("%description%", description)) : "";
                    StringBuilder argsBuilder = GlobalCommand.compileSubCommandArgs(subCommand.args());
                    String permission = subCommand.permission();
                    if (permission == null || sender.hasPermission(permission)) {
                        sender.sendMessage(DCTools.rc(DCTools.rt(this.backend.getAPI().getConfigManager().getMessages().getString("help-addons", "format", "command"), LocalPlaceholder.of("%cmd%", commandName), LocalPlaceholder.of("%args%", argsBuilder), LocalPlaceholder.of("%description%", description))));
                    }
                }));
            }
        });
    }

    @NotNull
    private static StringBuilder compileSubCommandArgs(String[] args) {
        StringBuilder builder = new StringBuilder();
        if (args != null) {
            for (String arg : args) {
                builder.append(arg).append(" ");
            }
            builder.setLength(builder.length() - 1);
        }
        return builder;
    }

    @Override
    public List<String> getTabCompletions(@NotNull DCCommandSender sender, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> value = new ArrayList<String>();
        if (args.length == 1) {
            Map<String, SubCommand> subCommands = this.backend.getAPI().getSubCommandManager().getMap();
            for (Map.Entry<String, SubCommand> entry : subCommands.entrySet()) {
                String subCommandName = entry.getKey();
                SubCommand subCommand = entry.getValue();
                String permission = subCommand.permission();
                if (permission != null && !sender.hasPermission(permission)) continue;
                value.add(subCommandName);
            }
        } else {
            SubCommand subCommand = this.backend.getAPI().getSubCommandManager().get(args[0].toLowerCase());
            if (subCommand == null) {
                return new ArrayList<String>();
            }
            return subCommand.getTabCompletions(sender, label, Arrays.copyOfRange(args, 1, args.length));
        }
        if (args[args.length - 1].isEmpty()) {
            Collections.sort(value);
            return value;
        }
        return value.stream().filter(tmp -> tmp.startsWith(args[args.length - 1])).sorted().collect(Collectors.toList());
    }
}

