/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.command.sub;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.InternalJavaAddon;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommandType;
import com.jodexindustries.donatecase.api.platform.DCCommandSender;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.command.DefaultCommand;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddonsCommand
extends DefaultCommand {
    private final DCAPI api;

    public AddonsCommand(DCAPI api) {
        super(api, "addons", SubCommandType.ADMIN);
        this.api = api;
    }

    @Override
    public boolean execute(@NotNull DCCommandSender sender, @NotNull String label, String[] args) {
        ArrayList<InternalJavaAddon> addons = new ArrayList<InternalJavaAddon>(this.api.getAddonManager().getMap().values());
        addons.sort(Comparator.comparing(InternalJavaAddon::getName));
        sender.sendMessage(DCTools.prefix("&7Currently loaded addons in DonateCase (&a" + addons.size() + "&7): " + this.compileAddons(addons)));
        return true;
    }

    @NotNull
    private StringBuilder compileAddons(List<InternalJavaAddon> addons) {
        StringBuilder builder = new StringBuilder();
        if (addons != null && !addons.isEmpty()) {
            for (int i = 0; i < addons.size(); ++i) {
                InternalJavaAddon addon = addons.get(i);
                String name = addon.isEnabled() ? "&a" + addon.getName() : "&c" + addon.getName();
                builder.append(name);
                if (i >= addons.size() - 1) continue;
                builder.append("&7, ");
            }
        }
        return builder;
    }
}

