/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.command.sub;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.database.DatabaseStatus;
import com.jodexindustries.donatecase.api.data.subcommand.SubCommandType;
import com.jodexindustries.donatecase.api.platform.DCCommandSender;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.command.DefaultCommand;
import com.jodexindustries.donatecase.common.tools.LocalPlaceholder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GiveKeyCommand
extends DefaultCommand {
    private final DCAPI api;

    public GiveKeyCommand(DCAPI api) {
        super(api, "givekey", SubCommandType.MODER);
        this.api = api;
    }

    @Override
    public boolean execute(@NotNull DCCommandSender sender, @NotNull String label, String[] args) {
        int keys;
        if (args.length < 3) {
            return false;
        }
        String plainName = args[0];
        String caseType = args[1];
        try {
            keys = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(DCTools.prefix(DCTools.rt(this.api.getConfigManager().getMessages().getString("number-format-exception"), LocalPlaceholder.of("%string%", args[2]))));
            return true;
        }
        if (this.api.getCaseManager().hasByType(caseType)) {
            Optional<CaseDefinition> optional = this.api.getCaseManager().getByType(caseType);
            if (!optional.isPresent()) {
                return true;
            }
            DCTools.formatPlayerName(plainName).thenAcceptAsync(playerName -> this.api.getCaseKeyManager().add(caseType, (String)playerName, keys).thenAcceptAsync(status -> {
                Set<LocalPlaceholder> placeholders = LocalPlaceholder.of((CaseDefinition)optional.get());
                placeholders.add(LocalPlaceholder.of("%player%", playerName));
                placeholders.add(LocalPlaceholder.of("%key%", keys));
                if (status == DatabaseStatus.COMPLETE) {
                    DCPlayer target;
                    sender.sendMessage(DCTools.prefix(DCTools.rt(this.api.getConfigManager().getMessages().getString("keys-given"), placeholders)));
                    if (!(args.length >= 4 && args[3].equalsIgnoreCase("-s") || (target = this.api.getPlatform().getPlayer((String)playerName)) == null)) {
                        target.sendMessage(DCTools.prefix(DCTools.rt(this.api.getConfigManager().getMessages().getString("keys-given-target"), placeholders)));
                    }
                }
            }));
        } else {
            sender.sendMessage(DCTools.prefix(DCTools.rt(this.api.getConfigManager().getMessages().getString("case-does-not-exist"), LocalPlaceholder.of("%casetype%", caseType))));
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(@NotNull DCCommandSender sender, @NotNull String label, String[] args) {
        return DCTools.resolveSDGCompletions(args);
    }
}

