/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.converter;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigMigrator;
import com.jodexindustries.donatecase.api.config.converter.ConfigType;
import com.jodexindustries.donatecase.api.config.converter.ConvertOrder;
import com.jodexindustries.donatecase.common.config.ConfigImpl;
import com.jodexindustries.donatecase.common.config.ConfigManagerImpl;
import java.util.ArrayList;
import java.util.logging.Level;
import org.spongepowered.configurate.ConfigurateException;

public class ConfigConverter {
    private final ConfigManagerImpl configManager;

    public ConfigConverter(ConfigManagerImpl configManager) {
        this.configManager = configManager;
    }

    public void convert(ConvertOrder order) {
        for (Config config : new ArrayList<ConfigImpl>(this.configManager.get().values())) {
            try {
                this.convert(config, order);
            }
            catch (ConfigurateException e) {
                this.configManager.getPlatform().getLogger().log(Level.WARNING, "Error with converting configuration: " + config, e);
            }
        }
    }

    public void convert(Config config, ConvertOrder order) throws ConfigurateException, IllegalArgumentException {
        ConfigMigrator migrator;
        ConfigType currentType;
        int version = config.version();
        if (version == (currentType = config.type()).getLatestVersion() && !currentType.isPermanent()) {
            return;
        }
        while ((version < currentType.getLatestVersion() || currentType.isPermanent()) && (migrator = currentType.getMigrator(version)) != null && migrator.order() == order && migrator.canMigrate()) {
            this.configManager.getPlatform().getLogger().info(config + " converting...");
            migrator.migrate(config);
            if (currentType.isPermanent()) {
                this.configManager.getPlatform().getLogger().info(config + " converted permanently from " + currentType + " to " + config.type());
                this.convert(config, order);
                break;
            }
            this.configManager.getPlatform().getLogger().info(config + " converted from " + version + " to " + ++version);
        }
        config.save();
    }
}

