/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.converter;

import com.jodexindustries.donatecase.api.config.converter.ConfigMigrator;
import com.jodexindustries.donatecase.api.config.converter.ConfigType;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItems;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import com.jodexindustries.donatecase.api.data.config.ConfigData;
import com.jodexindustries.donatecase.api.data.config.ConfigSerializer;
import com.jodexindustries.donatecase.common.config.converter.migrators.AnimationsMigrator_1_4_to_1_5;
import com.jodexindustries.donatecase.common.config.converter.migrators.CasesMigrator_1_0_to_1_1;
import com.jodexindustries.donatecase.common.config.converter.migrators.ConfigMigrator_2_5_to_2_6;
import com.jodexindustries.donatecase.common.config.converter.migrators.ConfigMigrator_2_6_to_2_7;
import com.jodexindustries.donatecase.common.config.converter.migrators.ConfigMigrator_2_7_to_2_8;
import com.jodexindustries.donatecase.common.config.converter.migrators.LanguageMigrator_2_6_to_2_7;
import com.jodexindustries.donatecase.common.config.converter.migrators.OldCaseMigrator_1_0_to_1_1;
import com.jodexindustries.donatecase.common.config.converter.migrators.OldCaseMigrator_1_1_to_1_2;
import com.jodexindustries.donatecase.common.config.converter.migrators.OldCaseMigrator_1_2_to_1_3;
import com.jodexindustries.donatecase.common.config.converter.migrators.OldCaseMigrator_1_3_to_1_4;
import com.jodexindustries.donatecase.common.config.converter.migrators.OldDataMigrator;
import com.jodexindustries.donatecase.common.config.converter.migrators.OldKeysMigrator;
import com.jodexindustries.donatecase.common.config.converter.migrators.UnknownMigrator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DefaultConfigType implements ConfigType
{
    OLD_CASE(14, (Map<Integer, ConfigMigrator>)new HashMap<Integer, ConfigMigrator>(){
        {
            this.put(10, new OldCaseMigrator_1_0_to_1_1());
            this.put(11, new OldCaseMigrator_1_1_to_1_2());
            this.put(12, new OldCaseMigrator_1_2_to_1_3());
            this.put(13, new OldCaseMigrator_1_3_to_1_4());
        }
    }),
    OLD_KEYS(1, (Map<Integer, ConfigMigrator>)new HashMap<Integer, ConfigMigrator>(){
        {
            this.put(0, new OldKeysMigrator());
        }
    }),
    OLD_DATA(1, (Map<Integer, ConfigMigrator>)new HashMap<Integer, ConfigMigrator>(){
        {
            this.put(0, new OldDataMigrator());
        }
    }),
    CASE_MENU(1, new ConfigSerializer(CaseMenu.class, new Object[0])),
    CASE_SETTINGS(1, new ConfigSerializer(CaseSettings.class, new Object[0])),
    CASE_ITEMS(1, new ConfigSerializer(CaseItems.class, "items")),
    ANIMATIONS(15, (Map<Integer, ConfigMigrator>)new HashMap<Integer, ConfigMigrator>(){
        {
            this.put(14, new AnimationsMigrator_1_4_to_1_5());
        }
    }),
    CASES(11, (Map<Integer, ConfigMigrator>)new HashMap<Integer, ConfigMigrator>(){
        {
            this.put(10, new CasesMigrator_1_0_to_1_1());
        }
    }),
    CONFIG(28, (Map<Integer, ConfigMigrator>)new HashMap<Integer, ConfigMigrator>(){
        {
            this.put(25, new ConfigMigrator_2_5_to_2_6());
            this.put(26, new ConfigMigrator_2_6_to_2_7());
            this.put(27, new ConfigMigrator_2_7_to_2_8());
        }
    }, new ConfigSerializer(ConfigData.class, new Object[0])),
    LANG(27, (Map<Integer, ConfigMigrator>)new HashMap<Integer, ConfigMigrator>(){
        {
            this.put(26, new LanguageMigrator_2_6_to_2_7());
        }
    }),
    UNKNOWN_CUSTOM(0),
    UNKNOWN(true, new UnknownMigrator());

    private int latestVersion;
    private boolean permanent;
    private ConfigMigrator permanentMigrator;
    private ConfigSerializer configSerializer;
    private Map<Integer, ConfigMigrator> migrations;

    private DefaultConfigType(int latestVersion) {
        this.latestVersion = latestVersion;
    }

    private DefaultConfigType(int latestVersion, ConfigSerializer configSerializer) {
        this(latestVersion);
        this.configSerializer = configSerializer;
    }

    private DefaultConfigType(int latestVersion, Map<Integer, ConfigMigrator> migrations) {
        this(latestVersion);
        this.migrations = migrations;
    }

    private DefaultConfigType(int latestVersion, Map<Integer, ConfigMigrator> migrations, ConfigSerializer configSerializer) {
        this(latestVersion, migrations);
        this.configSerializer = configSerializer;
    }

    private DefaultConfigType(boolean permanent, ConfigMigrator permanentMigrator) {
        this.permanent = permanent;
        this.permanentMigrator = permanentMigrator;
    }

    public boolean isUnknown() {
        return this == UNKNOWN || this == UNKNOWN_CUSTOM;
    }

    @Override
    public ConfigMigrator getMigrator(int version) {
        if (this.migrations == null) {
            return this.permanentMigrator;
        }
        return this.migrations.get(version);
    }

    @Override
    @Nullable
    public ConfigSerializer getConfigSerializer() {
        return this.configSerializer;
    }

    @Override
    public boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public int getLatestVersion() {
        return this.latestVersion;
    }

    @NotNull
    public static DefaultConfigType getType(String name) {
        if (name != null) {
            try {
                return DefaultConfigType.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return UNKNOWN_CUSTOM;
            }
        }
        return UNKNOWN;
    }
}

