/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.converter.migrators;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigMigrator;
import com.jodexindustries.donatecase.api.data.storage.CaseInfo;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class CasesMigrator_1_0_to_1_1
implements ConfigMigrator {
    @Override
    public void migrate(Config config) throws SerializationException {
        ConfigurationNode root = config.node("DonateCase", "Cases");
        HashMap<String, CaseInfo> cases = new HashMap<String, CaseInfo>();
        for (ConfigurationNode configurationNode : root.childrenMap().values()) {
            String key = String.valueOf(configurationNode.key());
            String caseType = configurationNode.node(new Object[]{"type"}).getString();
            String[] location = configurationNode.node(new Object[]{"location"}).getString("").split(";");
            if (location.length < 4) continue;
            CaseInfo caseInfo = CasesMigrator_1_0_to_1_1.getCaseInfo(location, caseType);
            cases.put(key, caseInfo);
        }
        config.node().removeChild((Object)"DonateCase");
        for (Map.Entry entry : cases.entrySet()) {
            root.node(new Object[]{entry.getKey()}).set(entry.getValue());
        }
        config.node("config", "version").set((Object)11);
    }

    @NotNull
    private static CaseInfo getCaseInfo(String[] location, String caseType) {
        String world = location[0];
        double x = Double.parseDouble(location[1]);
        double y = Double.parseDouble(location[2]);
        double z = Double.parseDouble(location[3]);
        float pitch = location.length > 4 ? Float.parseFloat(location[4]) : 0.0f;
        float yaw = location.length > 5 ? Float.parseFloat(location[5]) : 0.0f;
        CaseLocation caseLocation = new CaseLocation(world, x, y, z, pitch, yaw);
        return new CaseInfo(caseType, caseLocation);
    }
}

