/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.converter.migrators;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigMigrator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;

public class ConfigMigrator_2_5_to_2_6
implements ConfigMigrator {
    private final Map<String, String> renameMap = new LinkedHashMap<String, String>();

    public ConfigMigrator_2_5_to_2_6() {
        this.renameMap.put("UpdateChecker", "update-checker");
        this.renameMap.put("MySql", "mysql");
        this.renameMap.put("Languages", "language");
        this.renameMap.put("HologramDriver", "hologram-driver");
        this.renameMap.put("LevelGroups", "level-groups");
        this.renameMap.put("DateFormat", "date-format");
        this.renameMap.put("AddonsHelp", "addons-help");
        this.renameMap.put("UsePackets", "use-packets");
        this.renameMap.put("Caching", "caching");
        this.renameMap.put("CheckPlayerName", "format-player-name");
        this.renameMap.put("Enabled", "enabled");
        this.renameMap.put("Host", "host");
        this.renameMap.put("Port", "port");
        this.renameMap.put("DataBase", "database");
        this.renameMap.put("User", "username");
        this.renameMap.put("Password", "password");
    }

    @Override
    public void migrate(Config config) throws ConfigurateException {
        ConfigurationNode donateCase = this.getRoot(config).copy();
        if (!donateCase.virtual()) {
            ConfigurationNode language;
            String languageString;
            ConfigurationNode formatPlayerName;
            donateCase.removeChild((Object)"NoKeyWarningSound");
            donateCase.removeChild((Object)"SetKeysTargetMessage");
            donateCase.removeChild((Object)"PermissionDriver");
            donateCase.removeChild((Object)"LevelGroup");
            donateCase.removeChild((Object)"DisableSpawnProtection");
            this.renameKeysRecursively(donateCase);
            ConfigurationNode caching = donateCase.node(new Object[]{"caching"});
            if (caching.virtual()) {
                caching.set((Object)20);
            }
            if ((formatPlayerName = donateCase.node(new Object[]{"format-player-name"})).virtual()) {
                formatPlayerName.set((Object)false);
            }
            if ((languageString = (language = donateCase.node(new Object[]{"language"})).getString()) != null) {
                switch (languageString.toLowerCase()) {
                    case "ru": {
                        language.set((Object)"ru_RU");
                        break;
                    }
                    case "en": {
                        language.set((Object)"en_US");
                        break;
                    }
                    case "ua": {
                        language.set((Object)"ua_UA");
                    }
                }
            }
        }
        ConfigurationNode root = config.node();
        Object key = donateCase.key();
        if (key != null) {
            root.removeChild(key);
        }
        for (Map.Entry entry : donateCase.childrenMap().entrySet()) {
            root.node(new Object[]{entry.getKey()}).set(entry.getValue());
        }
        root.node(new Object[]{"config", "version"}).set((Object)26);
    }

    private ConfigurationNode getRoot(Config config) {
        ConfigurationNode donateCase = config.node("DonateCase");
        if (!donateCase.virtual()) {
            return donateCase;
        }
        return config.node("DonatCase");
    }

    private void renameKeysRecursively(ConfigurationNode node) {
        Map originalChildren = node.childrenMap();
        LinkedHashMap<String, ConfigurationNode> newChildren = new LinkedHashMap<String, ConfigurationNode>();
        for (Map.Entry entry : originalChildren.entrySet()) {
            String originalKey = entry.getKey().toString();
            ConfigurationNode originalChild = (ConfigurationNode)entry.getValue();
            String newKey = this.renameMap.getOrDefault(originalKey, originalKey);
            ConfigurationNode newChild = originalChild.copy();
            if (!originalChild.childrenMap().isEmpty()) {
                this.renameKeysRecursively(newChild);
            }
            newChildren.put(newKey, newChild);
        }
        node.raw(null);
        for (Map.Entry entry : newChildren.entrySet()) {
            node.node(new Object[]{entry.getKey()}).raw(((ConfigurationNode)entry.getValue()).raw());
        }
    }
}

