/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.converter.migrators;

import com.jodexindustries.donatecase.api.config.Config;
import com.jodexindustries.donatecase.api.config.converter.ConfigMigrator;
import com.jodexindustries.donatecase.api.config.converter.ConfigType;
import com.jodexindustries.donatecase.common.config.converter.DefaultConfigType;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class UnknownMigrator
implements ConfigMigrator {
    @Override
    public void migrate(Config config) throws SerializationException {
        String name = config.file().getName().toLowerCase();
        ConfigurationNode node = config.node();
        ConfigType type = config.type();
        switch (name) {
            case "animations.yml": {
                type = DefaultConfigType.ANIMATIONS;
                break;
            }
            case "config.yml": {
                type = DefaultConfigType.CONFIG;
                break;
            }
            case "cases.yml": {
                type = DefaultConfigType.CASES;
                break;
            }
            case "keys.yml": {
                type = DefaultConfigType.OLD_KEYS;
                break;
            }
            case "data.yml": {
                type = DefaultConfigType.OLD_DATA;
            }
        }
        if (config.path().contains("/lang")) {
            type = DefaultConfigType.LANG;
        }
        if (type == DefaultConfigType.UNKNOWN) {
            type = DefaultConfigType.UNKNOWN_CUSTOM;
        }
        node.removeChild((Object)"config");
        node.node(new Object[]{"config", "version"}).set((Object)config.version());
        node.node(new Object[]{"config", "type"}).set((Object)type);
        config.type(type);
    }
}

