/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.config.serializer.casedefinition;

import com.jodexindustries.donatecase.api.data.casedata.OpenType;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class CaseSettingsSerializer
implements TypeSerializer<CaseSettings> {
    public CaseSettings deserialize(Type type, ConfigurationNode node) throws SerializationException {
        String caseType = node.node(new Object[]{"type"}).getString();
        if (caseType == null) {
            throw new SerializationException("Case type cannot be null!");
        }
        String defaultMenu = node.node(new Object[]{"default-menu"}).getString();
        if (defaultMenu == null) {
            throw new SerializationException("Case default menu cannot be null!");
        }
        return new CaseSettings(caseType, defaultMenu, node.node(new Object[]{"animation"}).getString(), (CaseSettings.Hologram)node.node(new Object[]{"hologram"}).get(CaseSettings.Hologram.class), (CaseSettings.LevelGroups)node.node(new Object[]{"level-groups"}).get(CaseSettings.LevelGroups.class), node.node(new Object[]{"no-key-actions"}).getList(String.class), (OpenType)((Object)node.node(new Object[]{"open-type"}).get(OpenType.class)), node.node(new Object[]{"animation-settings"}), node.node(new Object[]{"cooldown-before-animation"}).getInt(), node.node(new Object[]{"history-data-size"}).getInt(), node.node(new Object[]{"display-name"}).getString());
    }

    public void serialize(Type type, @Nullable CaseSettings obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            return;
        }
        node.node(new Object[]{"type"}).set((Object)obj.type());
        node.node(new Object[]{"default-menu"}).set((Object)obj.defaultMenu());
        node.node(new Object[]{"animation"}).set((Object)obj.animation());
        node.node(new Object[]{"hologram"}).set(CaseSettings.Hologram.class, (Object)obj.hologram());
        node.node(new Object[]{"level-groups"}).set(CaseSettings.LevelGroups.class, (Object)obj.levelGroups());
        node.node(new Object[]{"no-key-actions"}).setList(String.class, obj.noKeyActions());
        node.node(new Object[]{"open-type"}).set(OpenType.class, (Object)obj.openType());
        node.node(new Object[]{"animation-settings"}).set((Object)obj.animationSettings());
        node.node(new Object[]{"cooldown-before-animation"}).set((Object)obj.cooldownBeforeAnimation());
        node.node(new Object[]{"history-data-size"}).set((Object)obj.historyDataSize());
        node.node(new Object[]{"display-name"}).set((Object)obj.displayName());
    }

    public static class Hologram
    implements TypeSerializer<CaseSettings.Hologram> {
        public CaseSettings.Hologram deserialize(Type type, ConfigurationNode node) throws SerializationException {
            return new CaseSettings.Hologram(node, node.node(new Object[]{"enabled"}).getBoolean(), node.node(new Object[]{"height"}).getDouble(), node.node(new Object[]{"range"}).getInt(), node.node(new Object[]{"message"}).getList(String.class));
        }

        public void serialize(Type type, @Nullable CaseSettings.Hologram obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                return;
            }
            node.node(new Object[]{"enabled"}).set((Object)obj.enabled());
            node.node(new Object[]{"height"}).set((Object)obj.height());
            node.node(new Object[]{"range"}).set((Object)obj.range());
            node.node(new Object[]{"message"}).setList(String.class, obj.message());
        }
    }

    public static class LevelGroups
    implements TypeSerializer<CaseSettings.LevelGroups> {
        public CaseSettings.LevelGroups deserialize(Type type, ConfigurationNode node) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            if (node.isMap()) {
                for (Map.Entry entry : node.childrenMap().entrySet()) {
                    map.put(String.valueOf(entry.getKey()), ((ConfigurationNode)entry.getValue()).getInt());
                }
            }
            return new CaseSettings.LevelGroups(map);
        }

        public void serialize(Type type, @Nullable CaseSettings.LevelGroups obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                return;
            }
            for (Map.Entry<String, Integer> entry : obj.map().entrySet()) {
                node.node(new Object[]{entry.getKey()}).set((Object)entry.getValue());
            }
        }

        public @Nullable CaseSettings.LevelGroups emptyValue(Type specificType, ConfigurationOptions options) {
            return new CaseSettings.LevelGroups();
        }
    }
}

