/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.entity.creator;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.PacketEventsAPI;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.item.ItemStack;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3f;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityRotation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandEulerAngle;
import com.jodexindustries.donatecase.api.armorstand.EquipmentSlot;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.entity.EntityEquipment;
import com.jodexindustries.donatecase.common.entity.meta.armorstand.ArmorStandMeta;
import io.github.retrooper.packetevents.adventure.serializer.legacy.LegacyComponentSerializer;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class APASC
implements ArmorStandCreator {
    private final PacketEventsAPI<?> api = PacketEvents.getAPI();
    private final UUID uuid = UUID.randomUUID();
    private final Collection<?> viewers;
    private final UUID animationId;
    private final ArmorStandMeta meta;
    private final EntityEquipment equipment;
    private CaseLocation location;

    public APASC(Collection<?> viewers, UUID animationId, int entityId, CaseLocation location) {
        this.viewers = viewers;
        this.animationId = animationId;
        this.meta = new ArmorStandMeta(entityId);
        this.equipment = new EntityEquipment(entityId);
        this.location = location;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        APASC that = (APASC)object;
        return this.getEntityId() == that.getEntityId();
    }

    public int hashCode() {
        return Objects.hashCode(this.getEntityId());
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.meta.setInvisible(!isVisible);
    }

    @Override
    public void setCustomName(@Nullable String displayName) {
        this.meta.setCustomName((Component)(displayName == null ? null : LegacyComponentSerializer.legacySection().deserialize(DCTools.rc(displayName))));
    }

    @Override
    public void teleport(CaseLocation location) {
        this.location = location;
        this.sendPacketToViewers(new PacketWrapper[]{new WrapperPlayServerEntityTeleport(this.meta.getEntityId(), this.getPosition(), location.yaw(), location.pitch(), false)});
    }

    protected void setEquipment0(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        switch (equipmentSlot) {
            case LEGS: {
                this.equipment.setLeggings(itemStack);
                break;
            }
            case FEET: {
                this.equipment.setBoots(itemStack);
                break;
            }
            case OFF_HAND: {
                this.equipment.setOffhand(itemStack);
                break;
            }
            case CHEST: {
                this.equipment.setChestplate(itemStack);
                break;
            }
            case HAND: {
                this.equipment.setMainHand(itemStack);
                break;
            }
            case HEAD: {
                this.equipment.setHelmet(itemStack);
            }
        }
        this.sendPacketToViewers(new PacketWrapper[]{this.equipment.createPacket()});
    }

    @Override
    public void setAngle(@NotNull ArmorStandEulerAngle angle) {
        this.meta.setHeadRotation(new Vector3f((float)angle.getHead().getX(), (float)angle.getHead().getY(), (float)angle.getHead().getZ()));
        this.meta.setLeftArmRotation(new Vector3f((float)angle.getLeftArm().getX(), (float)angle.getLeftArm().getY(), (float)angle.getLeftArm().getZ()));
        this.meta.setRightArmRotation(new Vector3f((float)angle.getRightArm().getX(), (float)angle.getRightArm().getY(), (float)angle.getRightArm().getZ()));
        this.meta.setBodyRotation(new Vector3f((float)angle.getBody().getX(), (float)angle.getBody().getY(), (float)angle.getBody().getZ()));
        this.meta.setLeftLegRotation(new Vector3f((float)angle.getLeftLeg().getX(), (float)angle.getLeftLeg().getY(), (float)angle.getLeftLeg().getZ()));
        this.meta.setRightLegRotation(new Vector3f((float)angle.getRightLeg().getX(), (float)angle.getRightLeg().getY(), (float)angle.getRightLeg().getZ()));
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.location.yaw(yaw);
        this.location.pitch(pitch);
        this.sendPacketToViewers(new PacketWrapper[]{new WrapperPlayServerEntityRotation(this.meta.getEntityId(), yaw, pitch, false), new WrapperPlayServerEntityHeadLook(this.meta.getEntityId(), yaw)});
    }

    @Override
    public void setGravity(boolean hasGravity) {
        this.meta.setHasNoGravity(hasGravity);
    }

    @Override
    public void setSmall(boolean small) {
        this.meta.setSmall(small);
    }

    @Override
    public void setMarker(boolean marker) {
        this.meta.setMarker(marker);
    }

    @Override
    public void setGlowing(boolean glowing) {
        this.meta.setGlowing(glowing);
    }

    @Override
    public boolean isGlowing() {
        return this.meta.isGlowing();
    }

    @Override
    public void setCollidable(boolean collidable) {
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.meta.setCustomNameVisible(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.meta.isCustomNameVisible();
    }

    @Override
    public CaseLocation getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public UUID getAnimationId() {
        return this.animationId;
    }

    @Override
    public int getEntityId() {
        return this.meta.getEntityId();
    }

    @Override
    public void remove() {
        ArmorStandCreator.armorStands.remove(this.meta.getEntityId());
        this.sendPacketToViewers(new PacketWrapper[]{new WrapperPlayServerDestroyEntities(this.meta.getEntityId())});
    }

    @Override
    public void spawn() {
        this.sendPacketToViewers(new PacketWrapper[]{new WrapperPlayServerSpawnEntity(this.meta.getEntityId(), Optional.of(this.uuid), EntityTypes.ARMOR_STAND, this.getPosition(), this.location.pitch(), this.location.yaw(), this.location.yaw(), 0, Optional.empty())});
        this.sendPacketToViewers(new PacketWrapper[]{this.meta.createPacket()});
    }

    @Override
    public void updateMeta() {
        this.sendPacketToViewers(new PacketWrapper[]{this.meta.createPacket()});
    }

    private void sendPacketToViewers(PacketWrapper<?> ... wrappers) {
        for (Object viewer : this.viewers) {
            for (PacketWrapper<?> wrapper : wrappers) {
                this.api.getPlayerManager().sendPacket(viewer, wrapper);
            }
        }
    }

    private Vector3d getPosition() {
        return new Vector3d(this.location.x(), this.location.y(), this.location.z());
    }
}

