/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.entity.meta;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.data.EntityMetadataProvider;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.jodexindustries.donatecase.common.entity.meta.Metadata;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMeta
implements EntityMetadataProvider {
    public static final byte OFFSET = 0;
    public static final byte MAX_OFFSET = 8;
    private static final byte ON_FIRE_BIT = 1;
    private static final byte CROUCHING_BIT = 2;
    private static final byte SPRINTING_BIT = 8;
    private static final byte SWIMMING_BIT = 16;
    private static final byte INVISIBLE_BIT = 32;
    private static final byte HAS_GLOWING_EFFECT_BIT = 64;
    private static final byte FLYING_WITH_ELYTRA_BIT = -128;
    protected final int entityId;
    protected final Metadata metadata;

    public EntityMeta(int entityId, Metadata metadata) {
        this.entityId = entityId;
        this.metadata = metadata;
    }

    public EntityMeta(EntityMeta other) {
        this(other.entityId, new Metadata(other.entityId));
        this.metadata.setMetaFromPacket(other.createPacket());
    }

    public EntityMeta(int entityId) {
        this(entityId, new Metadata(entityId));
    }

    public boolean isOnFire() {
        return this.getMaskBit((byte)0, (byte)1);
    }

    public void setOnFire(boolean value) {
        this.setMaskBit(0, (byte)1, value);
    }

    public boolean isSneaking() {
        return this.getMaskBit((byte)0, (byte)2);
    }

    public void setSneaking(boolean value) {
        this.setMaskBit(0, (byte)2, value);
    }

    public boolean isSprinting() {
        return this.getMaskBit((byte)0, (byte)8);
    }

    public void setSprinting(boolean value) {
        this.setMaskBit(0, (byte)8, value);
    }

    public boolean isInvisible() {
        return this.getMaskBit((byte)0, (byte)32);
    }

    public void setInvisible(boolean value) {
        this.setMaskBit(0, (byte)32, value);
    }

    public boolean hasGlowingEffect() {
        return this.getMaskBit((byte)0, (byte)64);
    }

    public boolean isGlowing() {
        return this.hasGlowingEffect();
    }

    public void setHasGlowingEffect(boolean value) {
        this.setMaskBit(0, (byte)64, value);
    }

    public void setGlowing(boolean value) {
        this.setHasGlowingEffect(value);
    }

    public boolean isSwimming() {
        return this.getMaskBit((byte)0, (byte)16);
    }

    public void setSwimming(boolean value) {
        this.setMaskBit(0, (byte)16, value);
    }

    public boolean isFlyingWithElytra() {
        return this.getMaskBit((byte)0, (byte)-128);
    }

    public void setFlyingWithElytra(boolean value) {
        this.setMaskBit(0, (byte)-128, value);
    }

    public short getAirTicks() {
        return this.metadata.getIndex((byte)1, (short)300);
    }

    public void setAirTicks(short value) {
        this.metadata.setIndex((byte)1, EntityDataTypes.SHORT, value);
    }

    public Component getCustomName() {
        Optional<Object> component = this.metadata.getIndex((byte)2, Optional.empty());
        return component.orElse(null);
    }

    public void setCustomName(Component value) {
        this.metadata.setIndex((byte)2, EntityDataTypes.OPTIONAL_ADV_COMPONENT, Optional.ofNullable(value));
    }

    public boolean isCustomNameVisible() {
        return this.metadata.getIndex((byte)3, false);
    }

    public void setCustomNameVisible(boolean value) {
        this.metadata.setIndex((byte)3, EntityDataTypes.BOOLEAN, value);
    }

    public boolean isSilent() {
        return this.metadata.getIndex((byte)4, false);
    }

    public void setSilent(boolean value) {
        this.metadata.setIndex((byte)4, EntityDataTypes.BOOLEAN, value);
    }

    public boolean hasNoGravity() {
        return this.metadata.getIndex((byte)5, true);
    }

    public void setHasNoGravity(boolean value) {
        this.metadata.setIndex((byte)5, EntityDataTypes.BOOLEAN, value);
    }

    public EntityPose getPose() {
        return this.metadata.getIndex((byte)6, EntityPose.STANDING);
    }

    public void setPose(EntityPose value) {
        this.metadata.setIndex((byte)6, EntityDataTypes.ENTITY_POSE, value);
    }

    public int getTicksFrozenInPowderedSnow() {
        return this.metadata.getIndex((byte)7, 0);
    }

    public void setTicksFrozenInPowderedSnow(int value) {
        this.metadata.setIndex((byte)7, EntityDataTypes.INT, value);
    }

    public WrapperPlayServerEntityMetadata createPacket() {
        return this.metadata.createPacket();
    }

    protected static byte offset(byte value, int amount) {
        return (byte)(value + amount);
    }

    public <T> void setIndex(byte index, @NotNull EntityDataType<T> dataType, T value) {
        this.metadata.setIndex(index, dataType, value);
    }

    public <T> T getIndex(byte index, @Nullable T defaultValue) {
        return this.metadata.getIndex(index, defaultValue);
    }

    public byte getMask(byte index) {
        return this.metadata.getIndex(index, (byte)0);
    }

    public void setMask(byte index, byte mask) {
        this.metadata.setIndex(index, EntityDataTypes.BYTE, mask);
    }

    public boolean getMaskBit(byte index, byte bit) {
        return (this.getMask(index) & bit) == bit;
    }

    public void setMaskBit(int index, byte bit, boolean value) {
        boolean currentValue;
        byte mask = this.getMask((byte)index);
        boolean bl = currentValue = (mask & bit) == bit;
        if (currentValue == value) {
            return;
        }
        mask = value ? (byte)(mask | bit) : (byte)(mask & (byte)(~bit));
        this.setMask((byte)index, mask);
    }

    @NotNull
    public List<EntityData<?>> entityData(@NotNull ClientVersion clientVersion) {
        return this.metadata.getEntries();
    }

    @Generated
    public int getEntityId() {
        return this.entityId;
    }

    @Generated
    public Metadata getMetadata() {
        return this.metadata;
    }
}

