/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.entity.meta;

import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.player.HumanoidArm;
import com.github.retrooper.packetevents.util.Vector3i;
import com.jodexindustries.donatecase.common.entity.meta.EntityMeta;
import java.util.Optional;

public class LivingEntityMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 15;
    private static final byte IS_HAND_ACTIVE_BIT = 1;
    private static final byte ACTIVE_HAND_BIT = 2;
    private static final byte IS_IN_SPIN_ATTACK_BIT = 4;

    public LivingEntityMeta(int entityId) {
        super(entityId);
    }

    public LivingEntityMeta(EntityMeta metadata) {
        super(metadata);
    }

    public float getHealth() {
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 1), Float.valueOf(1.0f)).floatValue();
    }

    public int getPotionEffectColor() {
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 2), 0);
    }

    public void setPotionEffectColor(int value) {
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 2), EntityDataTypes.INT, value);
    }

    public void setPotionEffectColor(int red, int green, int blue) {
        this.setPotionEffectColor(red << 16 + green << 8 + blue);
    }

    public boolean isPotionEffectAmbient() {
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 3), false);
    }

    public void setPotionEffectAmbient(boolean value) {
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 3), EntityDataTypes.BOOLEAN, value);
    }

    public int getArrowCount() {
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 4), 0);
    }

    public void setArrowCount(int value) {
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 4), EntityDataTypes.INT, value);
    }

    public void setHealth(float value) {
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 1), EntityDataTypes.FLOAT, Float.valueOf(value));
    }

    public HumanoidArm getActiveHand() {
        return this.getMaskBit((byte)8, (byte)2) ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    public void setActiveHand(HumanoidArm value) {
        this.setMaskBit(8, (byte)2, value == HumanoidArm.LEFT);
    }

    public boolean isInRiptideSpinAttack() {
        return this.getMaskBit((byte)8, (byte)4);
    }

    public void setInRiptideSpinAttack(boolean value) {
        this.setMaskBit(8, (byte)4, value);
    }

    public Optional<Vector3i> getBedPosition() {
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 6), Optional.empty());
    }

    public void setBedPosition(Vector3i value) {
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 6), EntityDataTypes.OPTIONAL_BLOCK_POSITION, value == null ? Optional.empty() : Optional.of(value));
    }

    public int getBeeStingerCount() {
        return this.metadata.getIndex(LivingEntityMeta.offset((byte)8, 5), 0);
    }

    public void setBeeStingerCount(int value) {
        this.metadata.setIndex(LivingEntityMeta.offset((byte)8, 5), EntityDataTypes.INT, value);
    }

    public boolean isHandActive() {
        return this.getMaskBit((byte)8, (byte)1);
    }

    public void setHandActive(boolean value) {
        this.setMaskBit(8, (byte)1, value);
    }
}

