/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.gui;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGui;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGuiWrapper;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseInventory;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItem;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItemException;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItemHandler;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMaterial;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.platform.Platform;
import com.jodexindustries.donatecase.api.scheduler.DCFuture;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.common.command.sub.KeysCommand;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaseGuiWrapperImpl
implements CaseGuiWrapper {
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    protected final Platform platform;
    protected final DCPlayer player;
    protected final CaseDefinition definition;
    protected final CaseLocation location;
    protected final CaseMenu menu;
    protected final CaseMenu temporary;
    protected final CaseInventory inventory;
    private List<CaseData.History> globalHistoryData;

    public CaseGuiWrapperImpl(@NotNull Platform platform, @NotNull DCPlayer player, @NotNull CaseDefinition definition, @NotNull CaseMenu caseMenu, @NotNull CaseLocation location) {
        this.platform = platform;
        this.player = player;
        this.definition = definition;
        this.location = location;
        this.menu = caseMenu;
        this.temporary = this.menu.clone();
        this.inventory = platform.getTools().createInventory(this, this.temporary.size(), DCTools.rc(this.setPlaceholders(this.temporary.title())));
        this.load().thenAcceptSync(loaded -> {
            player.openInventory(this.inventory.getHandle());
            this.startUpdateTask();
        }).exceptionally(ex -> {
            platform.getLogger().log(Level.WARNING, "GUI loading failed: " + ex.getMessage());
            player.sendMessage(DCTools.rc("&cFailed to load the GUI. Please try again later."));
            return null;
        });
    }

    private DCFuture<Void> load() {
        DCFuture<Void> future = new DCFuture<Void>();
        this.platform.getScheduler().async((Addon)this.platform, () -> {
            this.globalHistoryData = DCTools.sortHistoryDataByDate(this.platform.getAPI().getDatabase().getCache());
            for (CaseMenu.Item item : this.temporary.items().values()) {
                try {
                    this.processItem(item);
                }
                catch (TypedItemException e) {
                    this.platform.getLogger().log(Level.WARNING, "Error occurred while loading item: " + item.node().key(), e);
                }
            }
            future.complete(null);
        }, 0L);
        SCHEDULER.schedule(() -> {
            if (!future.isDone()) {
                future.completeExceptionally(new TimeoutException("GUI loading timed out"));
            }
        }, 5L, TimeUnit.SECONDS);
        return future;
    }

    private void updateMeta(CaseMenu.Item temp) {
        CaseMaterial original = this.getOriginal(temp.name());
        CaseMaterial material = temp.material();
        material.displayName(this.setPlaceholders(original.displayName()));
        material.lore(this.setPlaceholders(original.lore()));
        material.updateMeta();
    }

    private void startUpdateTask() {
        int updateRate = this.temporary.updateRate();
        if (updateRate >= 0) {
            this.platform.getScheduler().async((Addon)this.platform, task -> {
                if (!this.platform.getAPI().getGUIManager().getMap().containsKey(this.player.getUniqueId())) {
                    task.cancel();
                    return;
                }
                this.load();
            }, (long)updateRate, (long)updateRate);
        }
    }

    private CaseMaterial getOriginal(String itemName) {
        return this.menu.items().get(itemName).material();
    }

    private void processItem(CaseMenu.Item item) throws TypedItemException {
        String itemType = item.type();
        if (!itemType.equalsIgnoreCase("DEFAULT")) {
            Optional<TypedItem> typedItem = this.platform.getAPI().getGuiTypedItemManager().getFromString(itemType);
            if (typedItem.isPresent()) {
                TypedItemHandler handler = typedItem.get().handler();
                if (handler != null) {
                    item = handler.handle((CaseGuiWrapper)this, item);
                }
                if (typedItem.get().updateMeta()) {
                    this.updateMeta(item);
                }
            }
        } else {
            this.updateMeta(item);
        }
        CaseMaterial material = item.material();
        if (material.itemStack() == null) {
            material.itemStack(this.platform.getTools().loadCaseItem(material.id()));
        }
        material.updateMeta();
        for (Integer slot : item.slots()) {
            this.inventory.setItem(slot, item.material().itemStack());
        }
    }

    private String setPlaceholders(@Nullable String text) {
        if (text == null) {
            return null;
        }
        String caseType = this.definition.settings().type();
        text = this.platform.getPAPI().setPlaceholders(this.player, text);
        return KeysCommand.formatMessage(this.player.getName(), text.replace("%casetype%", caseType), true, caseType);
    }

    private List<String> setPlaceholders(List<String> lore) {
        return lore.stream().map(this::setPlaceholders).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public CaseInventory getInventory() {
        return this.inventory;
    }

    @Override
    @NotNull
    public CaseLocation getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public DCPlayer getPlayer() {
        return this.player;
    }

    @Override
    @Deprecated
    @NotNull
    public CaseData getCaseData() {
        return CaseData.fromDefinition(this.definition);
    }

    @Override
    @NotNull
    public CaseDefinition getDefinition() {
        return this.definition;
    }

    @Override
    @Deprecated
    public CaseGui getTemporary() {
        return CaseGui.fromMenu(this.menu);
    }

    @Override
    @NotNull
    public CaseMenu getMenu() {
        return this.temporary;
    }

    @Override
    @NotNull
    public List<CaseData.History> getGlobalHistoryData() {
        return this.globalHistoryData;
    }
}

