/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.gui.items;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.ActiveCase;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGuiWrapper;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItemClickHandler;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.database.DatabaseStatus;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.event.player.GuiClickEvent;
import com.jodexindustries.donatecase.api.event.player.OpenCaseEvent;
import com.jodexindustries.donatecase.api.event.player.PreOpenCaseEvent;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.platform.Platform;
import com.jodexindustries.donatecase.api.scheduler.DCFuture;
import org.jetbrains.annotations.NotNull;

public class OPENItemClickHandlerImpl
implements TypedItemClickHandler {
    private final DCAPI api = DCAPI.getInstance();
    private final Platform platform = this.api.getPlatform();

    @Override
    public void onClick(@NotNull GuiClickEvent e) {
        String[] parts;
        CaseGuiWrapper gui = e.guiWrapper();
        CaseLocation location = gui.getLocation();
        String itemType = e.itemType();
        CaseDefinition definition = gui.getDefinition();
        String caseType = definition.settings().type();
        if (itemType.contains("_") && (parts = itemType.split("_")).length >= 2) {
            caseType = parts[1];
            definition = this.api.getCaseManager().getByType(caseType).orElse(null);
        }
        if (definition != null) {
            e.player().closeInventory();
            OPENItemClickHandlerImpl.executeOpen(definition, e.player(), location);
        } else {
            this.platform.getLogger().warning("Case with type '" + caseType + "' not found. ");
        }
    }

    public static void executeOpen(@NotNull CaseDefinition definition, @NotNull DCPlayer player, @NotNull CaseLocation location) {
        PreOpenCaseEvent event = new PreOpenCaseEvent(player, definition, location);
        DCAPI.getInstance().getEventBus().post(event);
        if (event.cancelled()) {
            return;
        }
        OPENItemClickHandlerImpl.checkKeys(event).thenAcceptSync(hasKeys -> {
            if (hasKeys.booleanValue()) {
                OpenCaseEvent openEvent = new OpenCaseEvent(player, definition, location);
                DCAPI.getInstance().getEventBus().post(openEvent);
                if (!openEvent.cancelled()) {
                    OPENItemClickHandlerImpl.executeOpenWithoutEvent(player, location, definition, event.ignoreKeys());
                }
            } else {
                DCAPI.getInstance().getActionManager().execute(player, definition.settings().noKeyActions());
            }
        });
    }

    @Deprecated
    public static void executeOpen(@NotNull CaseData caseData, @NotNull DCPlayer player, @NotNull CaseLocation location) {
        OPENItemClickHandlerImpl.executeOpen(CaseData.toDefinition(caseData), player, location);
    }

    public static void executeOpenWithoutEvent(DCPlayer player, CaseLocation location, CaseDefinition definition, boolean ignoreKeys) {
        DCAPI.getInstance().getAnimationManager().start(player, location, definition).thenAcceptAsync(uuid -> {
            if (uuid != null) {
                ActiveCase activeCase = DCAPI.getInstance().getAnimationManager().getActiveCases().get(uuid);
                if (!ignoreKeys) {
                    DCAPI.getInstance().getCaseKeyManager().remove(definition.settings().type(), player.getName(), 1).thenAcceptAsync(status -> {
                        if (status == DatabaseStatus.COMPLETE) {
                            activeCase.keyRemoved(true);
                        }
                    });
                } else {
                    activeCase.keyRemoved(true);
                }
            }
        });
    }

    private static DCFuture<Boolean> checkKeys(PreOpenCaseEvent event) {
        if (event.ignoreKeys()) {
            return DCFuture.completedFuture(true);
        }
        return DCAPI.getInstance().getCaseKeyManager().getAsync(event.definition().settings().type(), event.player().getName()).thenApplySync(keys -> keys >= 1);
    }
}

