/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.InternalAddonClassLoader;
import com.jodexindustries.donatecase.api.addon.InternalAddonDescription;
import com.jodexindustries.donatecase.api.addon.InternalJavaAddon;
import com.jodexindustries.donatecase.api.addon.InvalidAddonException;
import com.jodexindustries.donatecase.api.addon.PowerReason;
import com.jodexindustries.donatecase.api.event.addon.AddonDisableEvent;
import com.jodexindustries.donatecase.api.event.addon.AddonEnableEvent;
import com.jodexindustries.donatecase.api.manager.AddonManager;
import com.jodexindustries.donatecase.api.platform.Platform;
import com.jodexindustries.donatecase.api.tools.DCTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class AddonManagerImpl
implements AddonManager {
    public final Map<String, InternalJavaAddon> addons = new ConcurrentHashMap<String, InternalJavaAddon>();
    public final List<InternalAddonClassLoader> loaders = new CopyOnWriteArrayList<InternalAddonClassLoader>();
    private MutableGraph<String> dependencyGraph = GraphBuilder.directed().build();
    private final DCAPI api;
    private final Platform platform;
    private final File folder;

    public AddonManagerImpl(DCAPI api) {
        this.api = api;
        this.platform = api.getPlatform();
        this.folder = new File(this.platform.getDataFolder(), "addons");
    }

    @Override
    public void load() {
        File addonsDir = this.folder;
        if (!addonsDir.exists() && !addonsDir.mkdir()) {
            return;
        }
        File[] files = addonsDir.listFiles();
        if (files == null) {
            return;
        }
        HashMap<String, InternalAddonDescription> descriptions = new HashMap<String, InternalAddonDescription>();
        for (File file : files) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try {
                InternalAddonDescription description = new InternalAddonDescription(file);
                descriptions.put(description.getName(), description);
                List<String> depend = description.getDepend();
                List<String> softDepend = description.getSoftDepend();
                for (String dependency : depend) {
                    this.dependencyGraph.putEdge((Object)description.getName(), (Object)dependency);
                }
                for (String softDependency : softDepend) {
                    this.dependencyGraph.putEdge((Object)description.getName(), (Object)softDependency);
                }
            }
            catch (InvalidAddonException | IOException e) {
                this.platform.getLogger().log(Level.SEVERE, "Failed to parse addon: " + file.getName(), e);
            }
        }
        List<String> loadOrder = this.resolveLoadOrder();
        if (loadOrder == null) {
            this.platform.getLogger().severe("Cyclic dependency detected! Aborting addon loading.");
            return;
        }
        for (String addonName : loadOrder) {
            InternalAddonDescription description = (InternalAddonDescription)descriptions.get(addonName);
            if (description == null) continue;
            this.loadAddon(description);
        }
        for (InternalAddonDescription description : descriptions.values()) {
            if (this.addons.containsKey(description.getName())) continue;
            this.loadAddon(description);
        }
    }

    private List<String> resolveLoadOrder() {
        ArrayList<String> sorted = new ArrayList<String>();
        HashSet<String> visited = new HashSet<String>();
        HashSet<String> visiting = new HashSet<String>();
        for (String addon : this.dependencyGraph.nodes()) {
            if (visited.contains(addon) || !this.topologicalSort(addon, sorted, visited, visiting)) continue;
            return null;
        }
        return sorted;
    }

    private boolean topologicalSort(String addon, List<String> sorted, Set<String> visited, Set<String> visiting) {
        if (visiting.contains(addon)) {
            return true;
        }
        if (visited.contains(addon)) {
            return false;
        }
        visiting.add(addon);
        for (String dependency : this.dependencyGraph.successors((Object)addon)) {
            if (!this.topologicalSort(dependency, sorted, visited, visiting)) continue;
            return true;
        }
        visiting.remove(addon);
        visited.add(addon);
        sorted.add(addon);
        return false;
    }

    private boolean loadAddon(InternalAddonDescription description) {
        this.platform.getLogger().info("Loading " + description.getName() + " addon v" + description.getVersion());
        if (this.addons.get(description.getName()) != null) {
            if (description.getName().equalsIgnoreCase("DonateCase")) {
                this.platform.getLogger().warning("Addon " + description.getName() + " trying to load with DonateCase name! Abort.");
                return false;
            }
            this.platform.getLogger().warning("Addon with name " + description.getName() + " already loaded!");
            return false;
        }
        if (description.getApiVersion() != null) {
            int addonVersion = DCTools.getPluginVersion(description.getApiVersion());
            int pluginVersion = DCTools.getPluginVersion("2.1.0.5");
            int supportedVersion = DCTools.getPluginVersion("2.1.0.0");
            if (pluginVersion < addonVersion || addonVersion < supportedVersion) {
                this.platform.getLogger().warning("Addon " + description.getName() + " API version (" + description.getApiVersion() + ") incompatible with current API version (" + "2.1.0.5" + ")! Abort.");
                return false;
            }
        }
        if (!description.isSupport(this.platform.getIdentifier())) {
            this.platform.getLogger().warning("Addon " + description.getName() + " does not support " + this.platform.getIdentifier() + " platform!");
            return false;
        }
        try {
            InternalAddonClassLoader loader = new InternalAddonClassLoader(this.platform.getClass().getClassLoader(), description, this, this.platform);
            InternalJavaAddon addon = loader.getAddon();
            addon.onLoad();
            this.addons.put(description.getName(), addon);
            this.loaders.add(loader);
            return true;
        }
        catch (Throwable e) {
            this.platform.getLogger().log(Level.SEVERE, "Error occurred while loading addon " + description.getName() + " v" + description.getVersion(), e);
            return false;
        }
    }

    @Override
    public boolean load(File file) {
        if (file.isFile() && file.getName().endsWith(".jar")) {
            InternalAddonDescription description;
            try {
                description = new InternalAddonDescription(file);
            }
            catch (InvalidAddonException | IOException e) {
                throw new RuntimeException(e);
            }
            return this.loadAddon(description);
        }
        return false;
    }

    @Override
    public void enable(PowerReason reason) {
        Collection<InternalJavaAddon> list = this.addons.values();
        for (InternalJavaAddon internalJavaAddon : list) {
            this.enable(internalJavaAddon, reason);
        }
    }

    @Override
    public boolean enable(@NotNull InternalJavaAddon addon, PowerReason reason) {
        try {
            if (!addon.isEnabled()) {
                this.platform.getLogger().info("Enabling " + addon.getName() + " addon v" + addon.getVersion());
                addon.setEnabled(true);
                this.api.getEventBus().post(new AddonEnableEvent(addon, reason));
                return true;
            }
        }
        catch (Throwable t) {
            this.platform.getLogger().log(Level.SEVERE, "Error occurred while enabling addon " + addon.getName() + " v" + addon.getVersion(), t);
        }
        return false;
    }

    @Override
    public boolean disable(@NotNull InternalJavaAddon addon, PowerReason reason) {
        try {
            if (addon.isEnabled()) {
                this.platform.getLogger().info("Disabling " + addon.getName() + " addon v" + addon.getVersion());
                addon.setEnabled(false);
                this.api.getActionManager().unregister(addon);
                this.api.getAnimationManager().unregister(addon);
                this.api.getGuiTypedItemManager().unregister(addon);
                this.api.getMaterialManager().unregister(addon);
                this.api.getSubCommandManager().unregister(addon);
                this.api.getEventBus().post(new AddonDisableEvent(addon, reason));
                return true;
            }
        }
        catch (Throwable t) {
            this.platform.getLogger().log(Level.SEVERE, "Error occurred while disabling addon " + addon.getName() + " v" + addon.getVersion(), t);
        }
        return false;
    }

    @Override
    public void unload(PowerReason reason) {
        ArrayList<InternalJavaAddon> list = new ArrayList<InternalJavaAddon>(this.addons.values());
        for (InternalJavaAddon internalJavaAddon : list) {
            this.unload(internalJavaAddon, reason);
        }
        this.dependencyGraph = GraphBuilder.directed().build();
        this.addons.clear();
        this.loaders.clear();
    }

    @Override
    public boolean unload(@NotNull InternalJavaAddon addon, PowerReason reason) {
        try {
            this.disable(addon, reason);
            this.addons.remove(addon.getName());
            this.loaders.remove(addon.getUrlClassLoader());
            addon.getUrlClassLoader().close();
            return true;
        }
        catch (Throwable e) {
            this.platform.getLogger().log(Level.SEVERE, e.getLocalizedMessage(), e.getCause());
            return false;
        }
    }

    @Override
    @Nullable
    public InternalJavaAddon get(String addon) {
        return this.addons.get(addon);
    }

    @Override
    @NotNull
    public Map<String, InternalJavaAddon> getMap() {
        return this.addons;
    }

    @Override
    @NotNull
    public File getFolder() {
        return this.folder;
    }

    @Override
    @Nullable
    public InternalAddonClassLoader getAddonClassLoader(File file) {
        return this.loaders.stream().filter(loader -> loader.getFile().equals(file)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Class<?> getClassByName(String name, boolean resolve) {
        for (InternalAddonClassLoader loader : this.loaders) {
            try {
                return loader.loadClass0(name, resolve, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

