/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.data.ActiveCase;
import com.jodexindustries.donatecase.api.data.animation.Animation;
import com.jodexindustries.donatecase.api.data.animation.CaseAnimation;
import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedata.GiveType;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGuiWrapper;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import com.jodexindustries.donatecase.api.data.storage.CaseInfo;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.event.animation.AnimationEndEvent;
import com.jodexindustries.donatecase.api.event.animation.AnimationPreStartEvent;
import com.jodexindustries.donatecase.api.event.animation.AnimationStartEvent;
import com.jodexindustries.donatecase.api.manager.AnimationManager;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.scheduler.DCFuture;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.api.tools.ProbabilityCollection;
import com.jodexindustries.donatecase.common.DonateCase;
import com.jodexindustries.donatecase.common.platform.BackendPlatform;
import com.jodexindustries.donatecase.common.tools.LocalPlaceholder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;

public class AnimationManagerImpl
implements AnimationManager {
    public final Map<String, CaseAnimation> registeredAnimations = new ConcurrentHashMap<String, CaseAnimation>();
    public final Map<UUID, ActiveCase> activeCases = new ConcurrentHashMap<UUID, ActiveCase>();
    public final Map<CaseLocation, List<UUID>> activeCasesByBlock = new ConcurrentHashMap<CaseLocation, List<UUID>>();
    private final DonateCase api;
    private final BackendPlatform backend;

    public AnimationManagerImpl(DonateCase api) {
        this.api = api;
        this.backend = api.getPlatform();
    }

    @Override
    public boolean register(CaseAnimation animation) {
        String name = animation.getName();
        if (!this.isRegistered(name)) {
            this.registeredAnimations.put(name, animation);
            return true;
        }
        this.backend.getLogger().warning("Animation " + name + " already registered!");
        return false;
    }

    @Override
    public void unregister(@NotNull String name) {
        if (this.isRegistered(name)) {
            this.registeredAnimations.remove(name);
        } else {
            this.backend.getLogger().warning("Animation with name " + name + " already unregistered!");
        }
    }

    @Override
    public void unregister() {
        ArrayList<String> list = new ArrayList<String>(this.registeredAnimations.keySet());
        list.forEach(this::unregister);
    }

    @Override
    public DCFuture<UUID> start(@NotNull DCPlayer player, @NotNull CaseLocation location, @NotNull CaseDefinition definition) {
        return this.start(player, location, definition, definition.settings().cooldownBeforeAnimation());
    }

    @Override
    public DCFuture<UUID> start(@NotNull DCPlayer player, @NotNull CaseLocation location, @NotNull CaseDefinition definition, int delay) {
        return this.start(player, location, definition, false, delay);
    }

    @Override
    public DCFuture<UUID> start(@NotNull DCPlayer player, @NotNull CaseLocation location, @NotNull CaseDefinition caseDefinition, boolean keyRemoved, int delay) {
        String animation;
        DCFuture<UUID> animationCompletion = new DCFuture<UUID>();
        CaseDefinition definition = caseDefinition.clone();
        if (!definition.settings().animation().equalsIgnoreCase("RANDOM")) {
            animation = definition.settings().animation();
        } else {
            animation = this.getRandomAnimation(this.getSettings(definition));
            definition.settings().animation(animation);
        }
        ConfigurationNode settings = this.getSettings(definition);
        CaseLocation temp = location.clone();
        CaseAnimation caseAnimation = this.get(animation);
        if (!this.validateStartConditions(definition, caseAnimation, settings, temp, player)) {
            animationCompletion.complete(null);
            return animationCompletion;
        }
        assert (caseAnimation != null);
        definition.items().items(DCTools.sortItemsByIndex(definition.items().items()));
        CaseItem winItem = definition.items().getRandomItem();
        winItem.material().displayName(this.api.getPlatform().getPAPI().setPlaceholders(player, winItem.material().displayName()));
        AnimationPreStartEvent event = new AnimationPreStartEvent(player, definition, temp, winItem);
        this.api.getEventBus().post(event);
        winItem = event.winItem();
        UUID uuid = UUID.randomUUID();
        if (caseAnimation.isRequireBlock()) {
            CaseSettings.Hologram hologram;
            CaseInfo info = this.api.getConfigManager().getCaseStorage().get(temp);
            if (info != null) {
                CaseLocation caseLocation = info.location();
                temp.pitch(caseLocation.pitch());
                temp.yaw(caseLocation.yaw());
            }
            if ((hologram = definition.settings().hologram()) != null && hologram.enabled()) {
                this.api.getHologramManager().remove(temp);
            }
            for (CaseGuiWrapper gui : this.api.getGUIManager().getMap().values()) {
                if (!gui.getLocation().equals(temp)) continue;
                gui.getPlayer().closeInventory();
            }
        }
        Class<? extends Animation> animationClass = caseAnimation.getAnimation();
        try {
            Animation javaAnimation = animationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            javaAnimation.init(player, temp.clone(), uuid, definition, winItem, settings);
            ActiveCase activeCase = new ActiveCase(uuid, temp, player, winItem, caseDefinition.clone(), javaAnimation);
            activeCase.locked(caseAnimation.isRequireBlock());
            activeCase.keyRemoved(keyRemoved);
            this.activeCases.put(uuid, activeCase);
            this.activeCasesByBlock.computeIfAbsent(temp, k -> new ArrayList()).add(uuid);
            this.api.getPlatform().getScheduler().run((Addon)this.backend, () -> {
                try {
                    javaAnimation.start();
                    animationCompletion.complete(uuid);
                    this.api.getEventBus().post(new AnimationStartEvent(activeCase));
                }
                catch (Throwable t) {
                    this.backend.getLogger().log(Level.WARNING, "Error with starting animation " + animation, t);
                    if (caseAnimation.isRequireBlock()) {
                        this.activeCasesByBlock.remove(temp);
                    }
                    this.activeCases.remove(uuid);
                    animationCompletion.complete(null);
                }
            }, (long)delay);
        }
        catch (Throwable t) {
            this.backend.getLogger().log(Level.WARNING, "Error with starting animation " + animation, t);
            if (caseAnimation.isRequireBlock()) {
                this.activeCasesByBlock.remove(location);
            }
            animationCompletion.complete(null);
        }
        return animationCompletion;
    }

    @Override
    public void preEnd(UUID uuid) {
        ActiveCase activeCase = this.activeCases.get(uuid);
        if (activeCase == null) {
            this.backend.getLogger().warning("Animation with uuid: " + uuid + " not found!");
            return;
        }
        Optional<CaseDefinition> optional = this.api.getCaseManager().getByType(activeCase.caseType());
        optional.ifPresent(definition -> this.preEnd((CaseDefinition)definition, activeCase.player(), activeCase.winItem()));
    }

    @Override
    public void preEnd(CaseDefinition definition, DCPlayer player, CaseItem item) {
        String primaryGroup;
        boolean alternative;
        CaseItem.RandomAction randomAction = item.giveType() == GiveType.ONE ? null : item.getRandomAction();
        CaseSettings.LevelGroups levelGroups = this.api.getConfigManager().getConfig().levelGroups();
        if (!definition.settings().levelGroups().map().isEmpty()) {
            levelGroups = definition.settings().levelGroups();
        }
        List<String> actions = (alternative = levelGroups.isBetterOrEqual(primaryGroup = this.backend.getLuckPermsSupport().getPrimaryGroup(player.getUniqueId()), item.group())) ? item.alternativeActions() : (randomAction == null ? item.actions() : randomAction.actions());
        this.executeActions(player, definition, item, actions);
        this.saveOpenInfo(definition, player, item, randomAction);
    }

    @Override
    public void end(UUID uuid) {
        ActiveCase activeCase = this.activeCases.get(uuid);
        if (activeCase == null) {
            this.backend.getLogger().warning("Animation with uuid: " + uuid + " not found!");
            return;
        }
        this.animationEnd(activeCase);
    }

    private void animationEnd(@NotNull ActiveCase activeCase) {
        CaseLocation block = activeCase.block();
        this.activeCases.remove(activeCase.uuid());
        this.activeCasesByBlock.remove(block);
        DCPlayer player = activeCase.player();
        if (!activeCase.keyRemoved()) {
            this.api.getCaseKeyManager().remove(activeCase.caseType(), player.getName(), 1);
        }
        this.api.getEventBus().post(new AnimationEndEvent(activeCase));
        CaseDefinition definition = activeCase.definition();
        CaseAnimation caseAnimation = this.get(definition.settings().animation());
        if (caseAnimation != null && caseAnimation.isRequireBlock()) {
            this.api.getHologramManager().create(block, definition.settings().hologram());
        }
    }

    @Override
    public boolean isRegistered(String name) {
        return this.registeredAnimations.containsKey(name);
    }

    @Override
    @Nullable
    public CaseAnimation get(String animation) {
        return this.registeredAnimations.get(animation);
    }

    @Override
    public Map<String, CaseAnimation> getMap() {
        return this.registeredAnimations;
    }

    @Override
    public Map<UUID, ActiveCase> getActiveCases() {
        return this.activeCases;
    }

    @Override
    public Map<CaseLocation, List<UUID>> getActiveCasesByBlock() {
        return this.activeCasesByBlock;
    }

    private boolean validateStartConditions(CaseDefinition definition, CaseAnimation animation, ConfigurationNode settings, CaseLocation location, DCPlayer player) {
        if (animation == null) {
            this.backend.getLogger().log(Level.WARNING, "Case animation " + definition.settings().animation() + " does not exist!");
            return false;
        }
        if (location.getWorld() == null || location.getWorld().name() == null) {
            this.backend.getLogger().warning("Player " + player.getName() + " trying to start animation without world name in case: " + definition.settings().type() + " Check the Cases.yml file!");
            return false;
        }
        if (this.isLocked(location)) {
            this.backend.getLogger().warning("Player " + player.getName() + " trying to start animation while another animation is running in case: " + definition.settings().type());
            return false;
        }
        if (animation.isRequireSettings() && settings == null) {
            this.backend.getLogger().warning("Animation " + animation + " requires settings for starting!");
            return false;
        }
        if (definition.items().items().isEmpty()) {
            this.backend.getLogger().warning("Player " + player.getName() + " trying to start animation without items in case: " + definition.settings().type());
            return false;
        }
        if (!definition.items().hasRealItems()) {
            this.backend.getLogger().warning("Player " + player.getName() + " trying to start animation without real (chance > 0) items in case: " + definition.settings().type());
            return false;
        }
        return true;
    }

    private void saveOpenInfo(@NotNull CaseDefinition definition, @NotNull DCPlayer player, @NotNull CaseItem item, @Nullable CaseItem.RandomAction action) {
        this.backend.getScheduler().async((Addon)this.backend, () -> {
            CaseData.History newEntry = new CaseData.History(item.name(), definition.settings().type(), player.getName(), System.currentTimeMillis(), item.group(), action == null ? null : action.name());
            this.api.getDatabase().addHistory(definition.settings().type(), newEntry, definition.settings().historyDataSize());
            this.api.getCaseOpenManager().add(definition.settings().type(), player.getName(), 1);
        }, 0L);
    }

    public void executeActions(DCPlayer player, CaseDefinition caseData, CaseItem item, List<String> actions) {
        Set<LocalPlaceholder> placeholders = LocalPlaceholder.of(caseData);
        placeholders.add(LocalPlaceholder.of("%player%", player.getName()));
        placeholders.addAll(LocalPlaceholder.of(item));
        this.api.getActionManager().execute(player, DCTools.rt(actions, placeholders));
    }

    public String getRandomAnimation(ConfigurationNode settings) {
        ProbabilityCollection collection = new ProbabilityCollection();
        settings.childrenMap().forEach((key, value) -> collection.add((String)key, value.getInt()));
        return (String)collection.get();
    }

    private ConfigurationNode getSettings(CaseDefinition definition) {
        return definition.settings().animationSettings().isNull() ? this.api.getConfigManager().getAnimations().node(new Object[]{definition.settings().animation()}) : definition.settings().animationSettings();
    }
}

