/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.database.DatabaseStatus;
import com.jodexindustries.donatecase.api.data.database.DatabaseType;
import com.jodexindustries.donatecase.api.event.plugin.KeysTransactionEvent;
import com.jodexindustries.donatecase.api.manager.CaseKeyManager;
import com.jodexindustries.donatecase.api.scheduler.DCFuture;
import java.util.Map;

public class CaseKeyManagerImpl
extends CaseKeyManager {
    private final DCAPI api;

    public CaseKeyManagerImpl(DCAPI api) {
        this.api = api;
    }

    private DCFuture<DatabaseStatus> setKeysWithEvent(String caseType, String player, int newKeys, int before) {
        KeysTransactionEvent event = new KeysTransactionEvent(caseType, player, newKeys, before);
        this.api.getEventBus().post(event);
        return !event.cancelled() ? this.api.getDatabase().setKeys(caseType, player, event.after()) : DCFuture.completedFuture(DatabaseStatus.CANCELLED);
    }

    @Override
    public DCFuture<DatabaseStatus> set(String caseType, String player, int keys) {
        return this.getAsync(caseType, player).thenComposeAsync(before -> this.setKeysWithEvent(caseType, player, keys, (int)before));
    }

    @Override
    public DCFuture<DatabaseStatus> modify(String caseType, String player, int keys) {
        return this.getAsync(caseType, player).thenComposeAsync(before -> this.setKeysWithEvent(caseType, player, before + keys, (int)before));
    }

    @Override
    public DCFuture<DatabaseStatus> delete() {
        return this.api.getDatabase().delAllKeys();
    }

    @Override
    public DCFuture<DatabaseStatus> delete(String caseType) {
        return this.api.getDatabase().delKeys(caseType);
    }

    @Override
    public DCFuture<Integer> getAsync(String caseType, String player) {
        return this.api.getDatabase().getKeys(caseType, player);
    }

    @Override
    public DCFuture<Map<String, Integer>> getAsync(String player) {
        return this.api.getDatabase().getKeys(player);
    }

    @Override
    public int getCache(String caseType, String player) {
        Integer keys = this.getCache(player).get(caseType);
        if (keys == null) {
            return 0;
        }
        return keys;
    }

    @Override
    public Map<String, Integer> getCache(String player) {
        Map keys;
        if (this.api.getDatabase().getType() == DatabaseType.SQLITE) {
            return this.get(player);
        }
        Map cachedKeys = (Map)cache.get(player);
        if (cachedKeys == null) {
            Map<String, Integer> previous = (Map<String, Integer>)cache.getPrevious(player);
            keys = previous != null ? previous : this.get(player);
            this.getAsync(player).thenAcceptAsync(map -> cache.put(player, map));
        } else {
            keys = cachedKeys;
        }
        return keys;
    }
}

