/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItem;
import com.jodexindustries.donatecase.api.manager.GUITypedItemManager;
import com.jodexindustries.donatecase.api.platform.Platform;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GUITypedItemManagerImpl
implements GUITypedItemManager {
    public final Map<String, TypedItem> registeredItems = new ConcurrentHashMap<String, TypedItem>();
    private final Platform platform;

    public GUITypedItemManagerImpl(DCAPI api) {
        this.platform = api.getPlatform();
    }

    @Override
    public boolean register(TypedItem item) {
        String id = item.id().toLowerCase();
        if (this.registeredItems.get(id) == null) {
            this.registeredItems.put(id, item);
            return true;
        }
        this.platform.getLogger().warning("Typed item " + id + " already registered!");
        return false;
    }

    @Override
    public void unregister(String id) {
        if (this.registeredItems.get(id) != null) {
            this.registeredItems.remove(id);
        } else {
            this.platform.getLogger().warning("Typed item " + id + " not registered!");
        }
    }

    @Override
    public void unregister() {
        ArrayList<String> items = new ArrayList<String>(this.registeredItems.keySet());
        items.forEach(this::unregister);
    }

    @Override
    @Nullable
    public TypedItem get(@NotNull String id) {
        return this.registeredItems.get(id.toLowerCase());
    }

    @Override
    @NotNull
    public Map<String, TypedItem> getMap() {
        return this.registeredItems;
    }

    @Override
    @Nullable
    public Optional<TypedItem> getFromString(@NotNull String string) {
        Optional<String> temp = this.getByStart(string);
        return temp.map(this::get);
    }
}

