/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.managers;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseSettings;
import com.jodexindustries.donatecase.api.data.hologram.HologramDriver;
import com.jodexindustries.donatecase.api.data.storage.CaseInfo;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.data.storage.CaseWorld;
import com.jodexindustries.donatecase.api.manager.HologramManager;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class HologramManagerImpl
implements HologramManager {
    private HologramDriver driver;
    private final Map<String, HologramDriver> drivers = new ConcurrentHashMap<String, HologramDriver>();
    private final DCAPI api;

    public HologramManagerImpl(DCAPI api) {
        this.api = api;
    }

    @Override
    public void register(@NotNull String name, @NotNull HologramDriver driver) {
        if (this.drivers.containsKey(name)) {
            return;
        }
        this.drivers.put(name, driver);
    }

    @Override
    public void unregister(@NotNull String name) {
        this.drivers.remove(name);
    }

    @Override
    public Map<String, HologramDriver> get() {
        return this.drivers;
    }

    @Override
    public void set(@NotNull String name) {
        this.driver = this.drivers.get(name);
    }

    @Override
    public void load() {
        String name = this.api.getConfigManager().getConfig().hologramDriver().toLowerCase();
        this.set(name);
        if (this.driver == null) {
            return;
        }
        this.api.getPlatform().getLogger().info("Using " + name + " as hologram driver");
        this.remove();
        for (Map.Entry<String, CaseInfo> entry : this.api.getConfigManager().getCaseStorage().get().entrySet()) {
            CaseSettings.Hologram hologram;
            CaseInfo info = entry.getValue();
            String caseType = info.type();
            Optional<CaseDefinition> optional = this.api.getCaseManager().getByType(caseType);
            if (!optional.isPresent() || !(hologram = optional.get().settings().hologram()).enabled()) continue;
            CaseLocation location = info.location();
            CaseWorld world = location.getWorld();
            if (this.api.getAnimationManager().isLocked(location)) continue;
            if (world == null || !this.api.getPlatform().isWorldLoaded(world.name())) {
                this.api.getPlatform().getLogger().warning("Hologram creation error. World is null for case name: " + entry.getKey());
                continue;
            }
            this.create(location, hologram);
        }
    }

    @Override
    public void forceCreate(@NotNull CaseLocation block,  @NotNull CaseSettings.Hologram hologram) {
        try {
            if (this.driver != null) {
                this.driver.forceCreate(block, hologram);
            }
        }
        catch (Exception e) {
            this.api.getPlatform().getLogger().log(Level.WARNING, "Error with creating hologram: ", e);
        }
    }

    @Override
    public void remove(@NotNull CaseLocation block) {
        if (this.driver != null) {
            this.driver.remove(block);
        }
    }

    @Override
    public void remove() {
        if (this.driver != null) {
            this.driver.remove();
        }
    }
}

