/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.platform;

import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseMenu;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.platform.Platform;
import com.jodexindustries.donatecase.common.gui.CaseGuiWrapperImpl;
import com.jodexindustries.donatecase.common.hook.LuckPermsSupport;
import com.jodexindustries.donatecase.common.scheduler.BackendScheduler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackendPlatform
implements Platform {
    @NotNull
    private final LuckPermsSupport luckPermsSupport = new LuckPermsSupport();
    private final BackendScheduler scheduler = new BackendScheduler();

    public abstract void load();

    public abstract void unload();

    public CaseGuiWrapperImpl createGui(DCPlayer player, CaseDefinition definition, CaseMenu menu, CaseLocation location) {
        return new CaseGuiWrapperImpl(this, player, definition, menu, location);
    }

    public final void saveResource(@NotNull String resourcePath, boolean replace) {
        if (resourcePath.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be empty");
        }
        InputStream in = this.getResource(resourcePath);
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found");
        }
        File outFile = new File(this.getDataFolder(), resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.getDataFolder(), resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists() && !outDir.mkdirs()) {
            this.getLogger().warning("Could not create folders for " + outFile.getName());
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
                in.close();
            } else {
                this.getLogger().log(Level.WARNING, "Could not save " + outFile.getName() + " to " + outFile + " because " + outFile.getName() + " already exists.");
            }
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, ex);
        }
    }

    @Nullable
    public final InputStream getResource(@NotNull String filename) {
        filename = filename.replace('\\', '/');
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    @NotNull
    public BackendScheduler getScheduler() {
        return this.scheduler;
    }

    @NotNull
    @Generated
    public LuckPermsSupport getLuckPermsSupport() {
        return this.luckPermsSupport;
    }
}

