/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.scheduler;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.scheduler.Scheduler;
import com.jodexindustries.donatecase.api.scheduler.SchedulerTask;
import com.jodexindustries.donatecase.common.scheduler.WrappedTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class BackendScheduler
implements Scheduler {
    private final ScheduledExecutorService syncExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger(0);

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r, "DonateCase-Sync-Thread-" + this.counter.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    });
    private final ForkJoinPool asyncExecutor = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, true);
    private final AtomicInteger taskCounter = new AtomicInteger(0);
    protected final ConcurrentMap<Integer, SchedulerTask> tasks = new ConcurrentHashMap<Integer, SchedulerTask>();

    protected void add(SchedulerTask task) {
        this.tasks.put(task.getTaskId(), task);
    }

    protected void remove(int taskId) {
        SchedulerTask task = (SchedulerTask)this.tasks.remove(taskId);
        if (task != null) {
            task.cancel();
        }
    }

    @Override
    public SchedulerTask run(Addon addon, Runnable task) {
        return this.schedule(addon, task, 0L, -1L, false);
    }

    @Override
    public SchedulerTask run(Addon addon, Runnable task, long delay) {
        return this.schedule(addon, task, delay, -1L, false);
    }

    @Override
    public SchedulerTask run(Addon addon, Runnable task, long delay, long period) {
        return this.schedule(addon, task, delay, period, false);
    }

    @Override
    public void run(Addon addon, Consumer<SchedulerTask> consumer) {
        this.scheduleConsumer(addon, consumer, 0L, -1L, false);
    }

    @Override
    public void run(Addon addon, Consumer<SchedulerTask> consumer, long delay) {
        this.scheduleConsumer(addon, consumer, delay, -1L, false);
    }

    @Override
    public void run(Addon addon, Consumer<SchedulerTask> consumer, long delay, long period) {
        this.scheduleConsumer(addon, consumer, delay, period, false);
    }

    @Override
    public SchedulerTask async(Addon addon, Runnable task, long delay) {
        return this.schedule(addon, task, delay, -1L, true);
    }

    @Override
    public SchedulerTask async(Addon addon, Runnable task, long delay, long period) {
        return this.schedule(addon, task, delay, period, true);
    }

    @Override
    public void async(Addon addon, Consumer<SchedulerTask> consumer, long delay) {
        this.scheduleConsumer(addon, consumer, delay, -1L, true);
    }

    @Override
    public void async(Addon addon, Consumer<SchedulerTask> consumer, long delay, long period) {
        this.scheduleConsumer(addon, consumer, delay, period, true);
    }

    private SchedulerTask schedule(Addon addon, Runnable task, long delayTicks, long periodTicks, boolean async) {
        long delayMs = delayTicks * 50L;
        long periodMs = periodTicks > 0L ? periodTicks * 50L : -1L;
        int id = this.taskCounter.incrementAndGet();
        WrappedTask wrappedTask = new WrappedTask(addon, id, !async, task);
        this.add(wrappedTask);
        if (async) {
            if (periodMs > 0L) {
                ScheduledFuture<?> future = this.syncExecutor.scheduleAtFixedRate(() -> this.asyncExecutor.execute(wrappedTask), delayMs, periodMs, TimeUnit.MILLISECONDS);
                wrappedTask.setFuture(future);
            } else if (delayMs > 0L) {
                ScheduledFuture<?> future = this.syncExecutor.schedule(() -> this.asyncExecutor.execute(wrappedTask), delayMs, TimeUnit.MILLISECONDS);
                wrappedTask.setFuture(future);
            } else {
                this.asyncExecutor.execute(wrappedTask);
            }
        } else {
            ScheduledFuture<?> future = periodMs > 0L ? this.syncExecutor.scheduleAtFixedRate(wrappedTask, delayMs, periodMs, TimeUnit.MILLISECONDS) : this.syncExecutor.schedule(wrappedTask, delayMs, TimeUnit.MILLISECONDS);
            wrappedTask.setFuture(future);
        }
        return wrappedTask;
    }

    private void scheduleConsumer(Addon addon, Consumer<SchedulerTask> consumer, long delayTicks, long periodTicks, boolean async) {
        WrappedTask wrappedTask;
        long delayMs = delayTicks * 50L;
        long periodMs = periodTicks > 0L ? periodTicks * 50L : -1L;
        int id = this.getId();
        WrappedTask[] wrapperHolder = new WrappedTask[1];
        Runnable task = () -> consumer.accept(wrapperHolder[0]);
        wrapperHolder[0] = wrappedTask = new WrappedTask(addon, id, !async, task);
        this.add(wrappedTask);
        if (async) {
            if (periodMs > 0L) {
                ScheduledFuture<?> future = this.syncExecutor.scheduleAtFixedRate(() -> this.asyncExecutor.execute(wrappedTask), delayMs, periodMs, TimeUnit.MILLISECONDS);
                wrappedTask.setFuture(future);
            } else if (delayMs > 0L) {
                ScheduledFuture<?> future = this.syncExecutor.schedule(() -> this.asyncExecutor.execute(wrappedTask), delayMs, TimeUnit.MILLISECONDS);
                wrappedTask.setFuture(future);
            } else {
                this.asyncExecutor.execute(wrappedTask);
            }
        } else {
            ScheduledFuture<?> future = periodMs > 0L ? this.syncExecutor.scheduleAtFixedRate(wrappedTask, delayMs, periodMs, TimeUnit.MILLISECONDS) : this.syncExecutor.schedule(wrappedTask, delayMs, TimeUnit.MILLISECONDS);
            wrappedTask.setFuture(future);
        }
    }

    protected int getId() {
        return this.taskCounter.incrementAndGet();
    }

    @Override
    public void cancel(int taskId, boolean external) {
        this.remove(taskId);
    }

    @Override
    public void shutdown() {
        this.syncExecutor.shutdownNow();
        this.asyncExecutor.shutdownNow();
        this.tasks.values().forEach(SchedulerTask::cancel);
        this.tasks.clear();
    }
}

