/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.scheduler;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.scheduler.SchedulerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import lombok.Generated;

public class WrappedTask
implements SchedulerTask {
    private final Addon owner;
    private final int taskId;
    private final boolean sync;
    private final Runnable r;
    private final Consumer<SchedulerTask> c;
    private volatile boolean cancelled = false;
    private ScheduledFuture<?> future;
    private final boolean external;

    public WrappedTask(Addon owner, int taskId, boolean sync, Object task) {
        this(owner, taskId, sync, task, false);
    }

    public WrappedTask(Addon owner, int taskId, boolean sync, Object task, boolean external) {
        this.owner = owner;
        this.taskId = taskId;
        this.sync = sync;
        this.external = external;
        if (task instanceof Runnable) {
            this.r = (Runnable)task;
            this.c = null;
        } else if (task instanceof Consumer) {
            this.r = null;
            this.c = (Consumer)task;
        } else {
            throw new IllegalArgumentException("Invalid task type: " + task.getClass());
        }
    }

    @Override
    public void run() {
        if (this.cancelled) {
            return;
        }
        try {
            if (this.r != null) {
                this.r.run();
            }
            if (this.c != null) {
                this.c.accept(this);
            }
        }
        catch (Throwable t) {
            DCAPI.getInstance().getPlatform().getLogger().log(Level.WARNING, "Exception while executing task: " + this.taskId, t);
        }
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public boolean isSync() {
        return this.sync;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled || this.future != null && this.future.isCancelled();
    }

    @Override
    public Addon getOwner() {
        return this.owner;
    }

    @Override
    public void cancel() {
        if (this.isCancelled()) {
            return;
        }
        this.cancelled = true;
        if (this.future != null) {
            this.future.cancel(false);
        }
        DCAPI.getInstance().getPlatform().getScheduler().cancel(this.taskId, this.external);
    }

    @Generated
    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }
}

