/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.common.tools;

import com.jodexindustries.donatecase.api.data.casedata.CaseData;
import com.jodexindustries.donatecase.api.data.casedata.CaseDataItem;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseDefinition;
import com.jodexindustries.donatecase.api.data.casedefinition.CaseItem;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.api.tools.Placeholder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class LocalPlaceholder
extends Placeholder {
    private LocalPlaceholder(String name, String value) {
        super(name, value);
    }

    public static LocalPlaceholder of(String name, Object value) {
        return new LocalPlaceholder(name, String.valueOf(value));
    }

    public static Set<LocalPlaceholder> of(CaseDefinition definition) {
        return new HashSet<LocalPlaceholder>(Arrays.asList(LocalPlaceholder.of("%casetype%", definition.settings().type()), LocalPlaceholder.of("%casedisplayname%", definition.settings().displayName()), LocalPlaceholder.of("%casetitle%", definition.settings().displayName()), LocalPlaceholder.of("%animation%", definition.settings().animation())));
    }

    public static Set<LocalPlaceholder> of(CaseItem item) {
        return new HashSet<LocalPlaceholder>(Arrays.asList(LocalPlaceholder.of("%group%", item.group()), LocalPlaceholder.of("%groupdisplayname%", item.material().displayName())));
    }

    public static Set<LocalPlaceholder> of(CaseData.History data) {
        String time = DCTools.getDateFormat().format(new Date(data.time()));
        String group = data.group();
        String action = data.action() != null ? data.action() : group;
        return new HashSet<LocalPlaceholder>(Arrays.asList(LocalPlaceholder.of("%group%", group), LocalPlaceholder.of("%action%", action), LocalPlaceholder.of("%player%", data.playerName()), LocalPlaceholder.of("%casetype%", data.caseType()), LocalPlaceholder.of("%casename%", data.caseType()), LocalPlaceholder.of("%time%", time)));
    }

    @Deprecated
    public static Set<LocalPlaceholder> of(CaseData caseData) {
        return new HashSet<LocalPlaceholder>(Arrays.asList(LocalPlaceholder.of("%casetype%", caseData.caseType()), LocalPlaceholder.of("%casename%", caseData.caseType()), LocalPlaceholder.of("%casedisplayname%", caseData.caseDisplayName()), LocalPlaceholder.of("%casetitle%", caseData.caseGui() != null ? caseData.caseGui().title() : ""), LocalPlaceholder.of("%animation%", caseData.animation())));
    }

    @Deprecated
    public static Set<LocalPlaceholder> of(CaseDataItem item) {
        return new HashSet<LocalPlaceholder>(Arrays.asList(LocalPlaceholder.of("%group%", item.group()), LocalPlaceholder.of("%groupdisplayname%", item.material().displayName())));
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LocalPlaceholder that = (LocalPlaceholder)object;
        return Objects.equals(this.name(), that.name());
    }

    public int hashCode() {
        return Objects.hashCode(this.name());
    }
}

