/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot;

import com.Zrips.CMI.Modules.ModuleHandling.CMIModule;
import com.jodexindustries.donatecase.api.data.action.CaseAction;
import com.jodexindustries.donatecase.api.data.animation.CaseAnimation;
import com.jodexindustries.donatecase.api.data.casedata.MetaUpdater;
import com.jodexindustries.donatecase.api.data.casedata.gui.typeditem.TypedItem;
import com.jodexindustries.donatecase.api.data.hologram.HologramDriver;
import com.jodexindustries.donatecase.api.data.material.CaseMaterial;
import com.jodexindustries.donatecase.api.data.storage.CaseWorld;
import com.jodexindustries.donatecase.api.event.player.ArmorStandCreatorInteractEvent;
import com.jodexindustries.donatecase.api.platform.DCOfflinePlayer;
import com.jodexindustries.donatecase.api.platform.DCPlayer;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.api.tools.PAPI;
import com.jodexindustries.donatecase.common.DonateCase;
import com.jodexindustries.donatecase.common.gui.items.HISTORYItemHandlerImpl;
import com.jodexindustries.donatecase.common.gui.items.OPENItemClickHandlerImpl;
import com.jodexindustries.donatecase.common.managers.ActionManagerImpl;
import com.jodexindustries.donatecase.common.managers.AnimationManagerImpl;
import com.jodexindustries.donatecase.common.managers.GUITypedItemManagerImpl;
import com.jodexindustries.donatecase.common.managers.HologramManagerImpl;
import com.jodexindustries.donatecase.common.managers.MaterialManagerImpl;
import com.jodexindustries.donatecase.common.platform.BackendPlatform;
import com.jodexindustries.donatecase.spigot.BukkitCommand;
import com.jodexindustries.donatecase.spigot.BukkitDonateCase;
import com.jodexindustries.donatecase.spigot.BukkitMetaUpdater;
import com.jodexindustries.donatecase.spigot.BukkitScheduler;
import com.jodexindustries.donatecase.spigot.actions.CommandActionExecutorImpl;
import com.jodexindustries.donatecase.spigot.actions.SoundActionExecutorImpl;
import com.jodexindustries.donatecase.spigot.actions.TitleActionExecutorImpl;
import com.jodexindustries.donatecase.spigot.animations.RainlyAnimation;
import com.jodexindustries.donatecase.spigot.animations.firework.FireworkAnimation;
import com.jodexindustries.donatecase.spigot.animations.pop.PopAnimation;
import com.jodexindustries.donatecase.spigot.animations.select.SelectAnimation;
import com.jodexindustries.donatecase.spigot.animations.select.SelectAnimationListener;
import com.jodexindustries.donatecase.spigot.animations.shape.ShapeAnimation;
import com.jodexindustries.donatecase.spigot.animations.wheel.WheelAnimation;
import com.jodexindustries.donatecase.spigot.api.platform.BukkitOfflinePlayer;
import com.jodexindustries.donatecase.spigot.holograms.CMIHologramsImpl;
import com.jodexindustries.donatecase.spigot.holograms.DecentHologramsImpl;
import com.jodexindustries.donatecase.spigot.holograms.FancyHologramsImpl;
import com.jodexindustries.donatecase.spigot.holograms.HolographicDisplaysImpl;
import com.jodexindustries.donatecase.spigot.hook.packetevents.PacketEventsSupport;
import com.jodexindustries.donatecase.spigot.hook.papi.PAPISupport;
import com.jodexindustries.donatecase.spigot.listener.EventListener;
import com.jodexindustries.donatecase.spigot.materials.BASE64MaterialHandlerImpl;
import com.jodexindustries.donatecase.spigot.materials.CHMaterialHandlerImpl;
import com.jodexindustries.donatecase.spigot.materials.HDBMaterialHandlerImpl;
import com.jodexindustries.donatecase.spigot.materials.HEADMaterialHandlerImpl;
import com.jodexindustries.donatecase.spigot.materials.IAMaterialHandlerImpl;
import com.jodexindustries.donatecase.spigot.materials.MCURLMaterialHandlerImpl;
import com.jodexindustries.donatecase.spigot.materials.OraxenMaterialHandlerImpl;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import com.jodexindustries.donatecase.spigot.tools.Metrics;
import com.jodexindustries.donatecase.spigot.tools.ToolsImpl;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitBackend
extends BackendPlatform {
    private final BukkitDonateCase plugin;
    private final DonateCase api;
    private final DCTools tools;
    private final BukkitScheduler scheduler;
    private PAPI papi;
    private PacketEventsSupport packetEventsSupport;
    private MetaUpdater metaUpdater;
    private Metrics metrics;

    public BukkitBackend(BukkitDonateCase plugin) {
        this.plugin = plugin;
        this.api = new DonateCase(this);
        this.tools = new ToolsImpl(this);
        this.scheduler = new BukkitScheduler(this);
    }

    @Override
    public void load() {
        this.papi = new PAPISupport(this);
        this.papi.register();
        this.metaUpdater = new BukkitMetaUpdater();
        this.registerDefaultCommand();
        this.registerDefaultGUITypedItems();
        this.registerDefaultAnimations();
        this.registerDefaultActions();
        this.registerDefaultMaterials();
        this.loadHologramDrivers();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EventListener(this), (Plugin)this.plugin);
        this.api.load();
        this.loadPacketEventsAPI();
        this.loadLuckPerms();
        this.loadMetrics();
    }

    @Override
    public void unload() {
        this.api.unload();
        if (this.packetEventsSupport != null) {
            this.packetEventsSupport.unload();
        }
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        Bukkit.getWorlds().stream().flatMap(world -> world.getEntitiesByClass(ArmorStand.class).stream()).filter(stand -> stand.hasMetadata("case")).forEach(Entity::remove);
    }

    @Override
    public PAPI getPAPI() {
        return this.papi;
    }

    @Override
    public MetaUpdater getMetaUpdater() {
        return this.metaUpdater;
    }

    @Override
    public String getName() {
        return this.plugin.getName();
    }

    @Override
    public String getIdentifier() {
        return "Bukkit";
    }

    @Override
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    @Override
    public DCTools getTools() {
        return this.tools;
    }

    @Override
    public DonateCase getAPI() {
        return this.api;
    }

    @Override
    @NotNull
    public BukkitScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public DCPlayer getPlayer(String name) {
        Player player = Bukkit.getPlayerExact((String)name);
        if (player == null) {
            return null;
        }
        return BukkitUtils.fromBukkit(player);
    }

    @Override
    public DCPlayer[] getOnlinePlayers() {
        return (DCPlayer[])Bukkit.getOnlinePlayers().stream().map(BukkitUtils::fromBukkit).toArray(DCPlayer[]::new);
    }

    @Override
    public DCOfflinePlayer[] getOfflinePlayers() {
        return (DCOfflinePlayer[])Arrays.stream(Bukkit.getOfflinePlayers()).map(BukkitOfflinePlayer::new).toArray(DCOfflinePlayer[]::new);
    }

    @Override
    @Nullable
    public CaseWorld getWorld(String world) {
        return BukkitUtils.fromBukkit(Bukkit.getWorld((String)world));
    }

    @Override
    public boolean isWorldLoaded(String world) {
        return Bukkit.getWorld((String)world) != null;
    }

    @Override
    public int getSpawnRadius() {
        return Bukkit.getSpawnRadius();
    }

    private void registerDefaultCommand() {
        PluginCommand command = this.plugin.getCommand("donatecase");
        BukkitCommand bukkitCommand = new BukkitCommand(this);
        if (command != null) {
            command.setExecutor((CommandExecutor)bukkitCommand);
            command.setTabCompleter((TabCompleter)bukkitCommand);
        }
    }

    private void registerDefaultGUITypedItems() {
        GUITypedItemManagerImpl manager = this.api.getGuiTypedItemManager();
        manager.register(TypedItem.builder().id("HISTORY").addon(this).description("Type for displaying the history of case openings").handler(new HISTORYItemHandlerImpl()).build());
        manager.register(TypedItem.builder().id("OPEN").addon(this).description("Type to open the case").click(new OPENItemClickHandlerImpl()).updateMeta(true).loadOnCase(true).build());
        this.getLogger().info("Registered " + manager.getMap().size() + " gui typed items");
    }

    private void registerDefaultAnimations() {
        AnimationManagerImpl manager = this.api.getAnimationManager();
        manager.register(CaseAnimation.builder().name("SHAPE").addon(this).animation(ShapeAnimation.class).description("Items flip through and a shape appears").requireSettings(true).requireBlock(true).build());
        manager.register(CaseAnimation.builder().name("RAINLY").addon(this).animation(RainlyAnimation.class).description("Rain drips from the clouds").requireSettings(true).requireBlock(true).build());
        manager.register(CaseAnimation.builder().name("FIREWORK").addon(this).animation(FireworkAnimation.class).description("Fireworks fly to the skies and a prize appears").requireSettings(true).requireBlock(true).build());
        manager.register(CaseAnimation.builder().name("WHEEL").addon(this).animation(WheelAnimation.class).description("Items resolve around the case").requireSettings(true).requireBlock(true).build());
        manager.register(CaseAnimation.builder().name("SELECT").addon(this).animation(SelectAnimation.class).description("Select your prize manually").requireSettings(true).requireBlock(true).build());
        this.api.getEventBus().register(ArmorStandCreatorInteractEvent.class, new SelectAnimationListener());
        manager.register(CaseAnimation.builder().name("POP").addon(this).animation(PopAnimation.class).description("Items pop").requireSettings(true).requireBlock(true).build());
        this.getLogger().info("Registered " + manager.getMap().size() + " animations");
    }

    private void registerDefaultActions() {
        ActionManagerImpl manager = this.api.getActionManager();
        manager.register(CaseAction.builder().name("[command]").addon(this).executor(new CommandActionExecutorImpl()).description("Sends a command to the console").build());
        manager.register(CaseAction.builder().name("[title]").addon(this).executor(new TitleActionExecutorImpl()).description("Sends a title to the player").build());
        manager.register(CaseAction.builder().name("[sound]").addon(this).executor(new SoundActionExecutorImpl()).description("Sends a sound to the player").build());
        this.getLogger().info("Registered " + manager.getMap().size() + " actions");
    }

    private void registerDefaultMaterials() {
        MaterialManagerImpl manager = this.api.getMaterialManager();
        manager.register(CaseMaterial.builder().id("BASE64").addon(this).handler(new BASE64MaterialHandlerImpl()).description("Heads from Minecraft-heads by BASE64 value").build());
        manager.register(CaseMaterial.builder().id("MCURL").addon(this).handler(new MCURLMaterialHandlerImpl()).description("Heads from Minecraft-heads by Minecrat-URL").build());
        manager.register(CaseMaterial.builder().id("HEAD").addon(this).handler(new HEADMaterialHandlerImpl()).description("Default Minecraft heads by nickname").build());
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
            manager.register(CaseMaterial.builder().id("IA").addon(this).handler(new IAMaterialHandlerImpl()).description("Items from ItemsAdder plugin").build());
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("Oraxen")) {
            manager.register(CaseMaterial.builder().id("ORAXEN").addon(this).handler(new OraxenMaterialHandlerImpl()).description("Items from Oraxen plugin").build());
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("CustomHeads")) {
            manager.register(CaseMaterial.builder().id("CH").addon(this).handler(new CHMaterialHandlerImpl()).description("Heads from CustomHeads plugin").build());
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("HeadDatabase")) {
            manager.register(CaseMaterial.builder().id("HDB").addon(this).handler(new HDBMaterialHandlerImpl()).description("Heads from HeadDatabase plugin").build());
        }
        this.getLogger().info("Registered " + manager.getMap().size() + " materials");
    }

    private void loadHologramDrivers() {
        HologramManagerImpl manager = this.api.getHologramManager();
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        HashMap<String, Supplier> drivers = new HashMap<String, Supplier>();
        drivers.put("CMI", () -> CMIModule.holograms.isEnabled() ? CMIHologramsImpl.class : null);
        drivers.put("DecentHolograms", () -> DecentHologramsImpl.class);
        drivers.put("HolographicDisplays", () -> HolographicDisplaysImpl.class);
        drivers.put("FancyHolograms", () -> FancyHologramsImpl.class);
        drivers.forEach((plugin, provider) -> {
            Class driver;
            if (pluginManager.isPluginEnabled(plugin) && (driver = (Class)provider.get()) != null) {
                try {
                    manager.register(plugin.toLowerCase(), (HologramDriver)driver.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.getLogger().log(Level.WARNING, "Error with loading " + plugin + " hologram driver: ", e);
                }
            }
        });
    }

    private void loadPacketEventsAPI() {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("packetevents")) {
            try {
                this.packetEventsSupport = new PacketEventsSupport(this);
            }
            catch (Throwable e) {
                this.getLogger().log(Level.WARNING, "Error hooking to packetevents: ", e);
            }
        }
    }

    private void loadLuckPerms() {
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("LuckPerms")) {
            this.getLuckPermsSupport().load();
        }
    }

    private void loadMetrics() {
        this.metrics = new Metrics((Plugin)this.plugin, 18709);
        this.metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.api.getConfigManager().getConfig().language()));
        this.metrics.addCustomChart(new Metrics.SimplePie("use_packets", () -> this.packetEventsSupport != null ? (this.packetEventsSupport.isUsePackets() ? "yes" : "no") : "no"));
        this.metrics.addCustomChart(new Metrics.SimplePie("hologram_driver", () -> this.api.getConfigManager().getConfig().hologramDriver()));
    }

    @Generated
    public BukkitDonateCase getPlugin() {
        return this.plugin;
    }

    @Generated
    public PacketEventsSupport getPacketEventsSupport() {
        return this.packetEventsSupport;
    }
}

