/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot;

import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.scheduler.SchedulerTask;
import com.jodexindustries.donatecase.common.scheduler.BackendScheduler;
import com.jodexindustries.donatecase.common.scheduler.WrappedTask;
import com.jodexindustries.donatecase.spigot.BukkitBackend;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class BukkitScheduler
extends BackendScheduler {
    private final Plugin plugin;
    private final org.bukkit.scheduler.BukkitScheduler scheduler;

    public BukkitScheduler(BukkitBackend backend) {
        this.plugin = backend.getPlugin();
        this.scheduler = this.plugin.getServer().getScheduler();
    }

    private WrappedTask wrapper(Addon addon, BukkitTask task) {
        return new WrappedTask(addon, task.getTaskId(), task.isSync(), task, true);
    }

    @Override
    public SchedulerTask run(Addon addon, Runnable task) {
        BukkitTask bukkitTask = this.scheduler.runTask(this.plugin, task);
        return this.wrapper(addon, bukkitTask);
    }

    @Override
    public SchedulerTask run(Addon addon, Runnable task, long delay) {
        BukkitTask bukkitTask = this.scheduler.runTaskLater(this.plugin, task, delay);
        return this.wrapper(addon, bukkitTask);
    }

    @Override
    public SchedulerTask run(Addon addon, Runnable task, long delay, long period) {
        BukkitTask bukkitTask = this.scheduler.runTaskTimer(this.plugin, task, delay, period);
        return this.wrapper(addon, bukkitTask);
    }

    @Override
    public void run(Addon addon, Consumer<SchedulerTask> task) {
        this.scheduler.runTask(this.plugin, bukkitTask -> {
            WrappedTask wrappedTask = this.wrapper(addon, (BukkitTask)bukkitTask);
            task.accept(wrappedTask);
        });
    }

    @Override
    public void run(Addon addon, Consumer<SchedulerTask> task, long delay) {
        this.scheduler.runTaskLater(this.plugin, bukkitTask -> {
            WrappedTask wrappedTask = this.wrapper(addon, (BukkitTask)bukkitTask);
            task.accept(wrappedTask);
        }, delay);
    }

    @Override
    public void run(Addon addon, Consumer<SchedulerTask> task, long delay, long period) {
        this.scheduler.runTaskTimer(this.plugin, bukkitTask -> {
            WrappedTask wrappedTask = this.wrapper(addon, (BukkitTask)bukkitTask);
            task.accept(wrappedTask);
        }, delay, period);
    }

    @Override
    public void cancel(int taskId, boolean external) {
        super.cancel(taskId, external);
        if (external) {
            this.scheduler.cancelTask(taskId);
        }
    }
}

