/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.animations.firework;

import com.jodexindustries.donatecase.api.DCAPI;
import com.jodexindustries.donatecase.api.addon.Addon;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.scheduler.SchedulerTask;
import com.jodexindustries.donatecase.spigot.animations.firework.FireworkSettings;
import com.jodexindustries.donatecase.spigot.api.animation.BukkitJavaAnimation;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import com.jodexindustries.donatecase.spigot.tools.DCToolsBukkit;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.World;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.spongepowered.configurate.serialize.SerializationException;

public class FireworkAnimation
extends BukkitJavaAnimation {
    private static final DCAPI api = DCAPI.getInstance();
    private FireworkSettings settings;

    @Override
    public void start() {
        try {
            this.settings = (FireworkSettings)this.getSettings().get(FireworkSettings.class);
        }
        catch (SerializationException e) {
            throw new RuntimeException("Error with parsing animation settings", e);
        }
        this.getLocation().add(this.settings.startPosition);
        ArmorStandCreator as = DCAPI.getInstance().getPlatform().getTools().createArmorStand(this.getUuid(), this.getLocation());
        if (this.settings.pose != null) {
            as.setAngle(this.settings.pose);
        }
        as.setSmall(this.settings.small);
        as.setVisible(false);
        as.setGravity(false);
        as.spawn();
        api.getPlatform().getScheduler().run((Addon)api.getPlatform(), new Task(as), 0L, (long)this.settings.scroll.period);
    }

    private class Task
    implements Consumer<SchedulerTask> {
        private int tick;
        private final CaseLocation location;
        private final ArmorStandCreator as;
        private final World world;

        public Task(ArmorStandCreator as) {
            this.as = as;
            this.location = as.getLocation();
            this.world = FireworkAnimation.this.getPlayer().getWorld();
        }

        @Override
        public void accept(SchedulerTask task) {
            if (this.tick == 0) {
                Firework firework = (Firework)this.world.spawn(BukkitUtils.toBukkit(this.location), Firework.class);
                FireworkMeta data = firework.getFireworkMeta();
                data.addEffects(new FireworkEffect[]{FireworkEffect.builder().withColor(Color.PURPLE).withColor(Color.RED).with(FireworkEffect.Type.BALL).withFlicker().build()});
                for (String color : ((FireworkAnimation)FireworkAnimation.this).settings.fireworkColors) {
                    data.addEffect(FireworkEffect.builder().withColor(DCToolsBukkit.parseColor(color)).build());
                }
                data.setPower(((FireworkAnimation)FireworkAnimation.this).settings.power);
                firework.setFireworkMeta(data);
            }
            if (this.tick == 10) {
                this.as.setEquipment(((FireworkAnimation)FireworkAnimation.this).settings.itemSlot, FireworkAnimation.this.getItem().material().itemStack());
                if (FireworkAnimation.this.getItem().material().displayName() != null && !FireworkAnimation.this.getItem().material().displayName().isEmpty()) {
                    this.as.setCustomNameVisible(true);
                }
                this.as.setCustomName(DCAPI.getInstance().getPlatform().getPAPI().setPlaceholders(FireworkAnimation.this.getPlayer(), FireworkAnimation.this.getItem().material().displayName()));
                this.as.updateMeta();
                FireworkAnimation.this.preEnd();
            }
            if (this.tick >= 10 && this.tick < 60) {
                this.location.yaw(this.location.yaw() + ((FireworkAnimation)FireworkAnimation.this).settings.scroll.yaw);
                this.as.teleport(this.location);
            }
            if (this.tick >= 60) {
                this.as.remove();
                task.cancel();
                FireworkAnimation.this.end();
            }
            ++this.tick;
        }
    }
}

