/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.api.armorstand;

import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.armorstand.ArmorStandEulerAngle;
import com.jodexindustries.donatecase.api.armorstand.EquipmentSlot;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.jetbrains.annotations.NotNull;

public class EntityArmorStandCreator
implements ArmorStandCreator {
    private final UUID animationId;
    private final ArmorStand entity;

    public EntityArmorStandCreator(UUID animationId, Location location) {
        this.animationId = animationId;
        World world = location.getWorld();
        if (world == null) {
            this.entity = null;
            return;
        }
        this.entity = (ArmorStand)world.spawn(location, ArmorStand.class);
        this.entity.setMetadata("case", (MetadataValue)new FixedMetadataValue(BukkitUtils.getDonateCase(), (Object)"case"));
        ArmorStandCreator.armorStands.put(this.entity.getEntityId(), this);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EntityArmorStandCreator that = (EntityArmorStandCreator)object;
        return Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hashCode(this.entity);
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.entity.setVisible(isVisible);
    }

    @Override
    public void setSmall(boolean small) {
        this.entity.setSmall(small);
    }

    @Override
    public void setMarker(boolean marker) {
        this.entity.setMarker(marker);
    }

    @Override
    public void setGlowing(boolean glowing) {
        this.entity.setGlowing(glowing);
    }

    @Override
    public boolean isGlowing() {
        return this.entity.isGlowing();
    }

    @Override
    public void setCollidable(boolean collidable) {
        this.entity.setCollidable(collidable);
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.entity.setCustomNameVisible(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.entity.isCustomNameVisible();
    }

    @Override
    public void setCustomName(String displayName) {
        this.entity.setCustomName(DCTools.rc(displayName));
    }

    @Override
    public void teleport(CaseLocation location) {
        this.entity.teleport(BukkitUtils.toBukkit(location));
    }

    @Override
    public void setEquipment(EquipmentSlot equipmentSlot, Object item) {
        EntityEquipment equipment = this.entity.getEquipment();
        if (equipment != null) {
            equipment.setItem(org.bukkit.inventory.EquipmentSlot.valueOf((String)equipmentSlot.name()), (ItemStack)item);
        }
    }

    @Override
    public void setAngle(@NotNull ArmorStandEulerAngle angle) {
        this.entity.setHeadPose(BukkitUtils.toBukkit(angle.getHead()));
        this.entity.setBodyPose(BukkitUtils.toBukkit(angle.getBody()));
        this.entity.setLeftArmPose(BukkitUtils.toBukkit(angle.getLeftArm()));
        this.entity.setRightArmPose(BukkitUtils.toBukkit(angle.getRightArm()));
        this.entity.setLeftLegPose(BukkitUtils.toBukkit(angle.getLeftLeg()));
        this.entity.setRightLegPose(BukkitUtils.toBukkit(angle.getRightLeg()));
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        this.entity.setRotation(yaw, pitch);
    }

    @Override
    public CaseLocation getLocation() {
        return BukkitUtils.fromBukkit(this.entity.getLocation());
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.entity.getUniqueId();
    }

    @Override
    public UUID getAnimationId() {
        return this.animationId;
    }

    @Override
    public int getEntityId() {
        return this.entity.getEntityId();
    }

    @Override
    public void setGravity(boolean hasGravity) {
        this.entity.setGravity(hasGravity);
    }

    @Override
    public void remove() {
        ArmorStandCreator.armorStands.remove(this.entity.getEntityId());
        this.entity.remove();
    }
}

