/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.serializer;

import io.leangen.geantyref.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class ConfigurationSectionImpl
implements ConfigurationSection {
    private final ConfigurationNode node;

    public ConfigurationSectionImpl(ConfigurationNode node) {
        this.node = node;
    }

    public ConfigurationNode node(String path) {
        return this.node.node((Object[])path.split("\\."));
    }

    @NotNull
    public Set<String> getKeys(boolean deep) {
        return this.node.childrenMap().values().stream().map(ConfigurationNode::getString).collect(Collectors.toSet());
    }

    @NotNull
    public Map<String, Object> getValues(boolean deep) {
        Map map = this.node.childrenMap();
        return map.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> new ConfigurationSectionImpl((ConfigurationNode)entry.getValue()), (a, b) -> b));
    }

    public boolean contains(@NotNull String path) {
        return !this.node(path).isNull();
    }

    public boolean contains(@NotNull String path, boolean ignoreDefault) {
        return this.contains(path);
    }

    public boolean isSet(@NotNull String path) {
        return this.node(path).isList();
    }

    @Nullable
    public String getCurrentPath() {
        return this.node.path().toString();
    }

    @NotNull
    public String getName() {
        return String.valueOf(this.node.key());
    }

    @Nullable
    public Configuration getRoot() {
        return null;
    }

    @Nullable
    public ConfigurationSection getParent() {
        if (this.node.parent() == null) {
            return null;
        }
        return new ConfigurationSectionImpl(this.node.parent());
    }

    @Nullable
    public Object get(@NotNull String path) {
        return this.node(path).raw();
    }

    @Nullable
    public Object get(@NotNull String path, @Nullable Object def) {
        return this.node(path).raw(def);
    }

    public void set(@NotNull String path, @Nullable Object value) {
    }

    @NotNull
    public ConfigurationSection createSection(@NotNull String path) {
        return null;
    }

    @NotNull
    public ConfigurationSection createSection(@NotNull String path, @NotNull Map<?, ?> map) {
        return null;
    }

    @Nullable
    public String getString(@NotNull String path) {
        return this.node(path).getString();
    }

    @Nullable
    public String getString(@NotNull String path, @Nullable String def) {
        String string = this.getString(path);
        return string == null ? def : string;
    }

    public boolean isString(@NotNull String path) {
        return false;
    }

    public int getInt(@NotNull String path) {
        return this.node(path).getInt();
    }

    public int getInt(@NotNull String path, int def) {
        return this.node(path).getInt(def);
    }

    public boolean isInt(@NotNull String path) {
        return this.node(path).raw() instanceof Integer;
    }

    public boolean getBoolean(@NotNull String path) {
        return this.node(path).getBoolean();
    }

    public boolean getBoolean(@NotNull String path, boolean def) {
        return this.node(path).getBoolean(def);
    }

    public boolean isBoolean(@NotNull String path) {
        return this.node(path).raw() instanceof Boolean;
    }

    public double getDouble(@NotNull String path) {
        return this.node(path).getDouble();
    }

    public double getDouble(@NotNull String path, double def) {
        return this.node(path).getDouble(def);
    }

    public boolean isDouble(@NotNull String path) {
        return this.node(path).raw() instanceof Double;
    }

    public long getLong(@NotNull String path) {
        return this.node(path).getLong();
    }

    public long getLong(@NotNull String path, long def) {
        return this.node(path).getLong(def);
    }

    public boolean isLong(@NotNull String path) {
        return this.node(path).raw() instanceof Long;
    }

    @Nullable
    public List<?> getList(@NotNull String path) {
        try {
            return this.node(path).getList(Object.class);
        }
        catch (SerializationException e) {
            return null;
        }
    }

    @Nullable
    public List<?> getList(@NotNull String path, @Nullable List<?> def) {
        List<?> list = this.getList(path);
        return list == null ? def : list;
    }

    public boolean isList(@NotNull String path) {
        return false;
    }

    @NotNull
    public List<String> getStringList(@NotNull String path) {
        try {
            List list = this.node(path).getList(String.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<String>();
        }
    }

    @NotNull
    public List<Integer> getIntegerList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Integer.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Integer>();
        }
    }

    @NotNull
    public List<Boolean> getBooleanList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Boolean.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Boolean>();
        }
    }

    @NotNull
    public List<Double> getDoubleList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Double.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Double>();
        }
    }

    @NotNull
    public List<Float> getFloatList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Float.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Float>();
        }
    }

    @NotNull
    public List<Long> getLongList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Long.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Long>();
        }
    }

    @NotNull
    public List<Byte> getByteList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Byte.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Byte>();
        }
    }

    @NotNull
    public List<Character> getCharacterList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Character.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Character>();
        }
    }

    @NotNull
    public List<Short> getShortList(@NotNull String path) {
        try {
            List list = this.node(path).getList(Short.class);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList<Short>();
        }
    }

    @NotNull
    public List<Map<?, ?>> getMapList(@NotNull String path) {
        TypeToken typeToken = new TypeToken<Map<?, ?>>(){};
        try {
            List list = this.node.getList(typeToken);
            return list == null ? new ArrayList() : list;
        }
        catch (SerializationException e) {
            return new ArrayList();
        }
    }

    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz) {
        try {
            return (T)this.node(path).get(clazz);
        }
        catch (SerializationException e) {
            return null;
        }
    }

    @Nullable
    public <T> T getObject(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        try {
            return (T)this.node(path).get(clazz, def);
        }
        catch (SerializationException e) {
            return null;
        }
    }

    @Nullable
    public <T extends ConfigurationSerializable> T getSerializable(@NotNull String path, @NotNull Class<T> clazz) {
        return null;
    }

    @Nullable
    public <T extends ConfigurationSerializable> T getSerializable(@NotNull String path, @NotNull Class<T> clazz, @Nullable T def) {
        return null;
    }

    @Nullable
    public Vector getVector(@NotNull String path) {
        return null;
    }

    @Nullable
    public Vector getVector(@NotNull String path, @Nullable Vector def) {
        return null;
    }

    public boolean isVector(@NotNull String path) {
        return false;
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer(@NotNull String path) {
        return null;
    }

    @Nullable
    public OfflinePlayer getOfflinePlayer(@NotNull String path, @Nullable OfflinePlayer def) {
        return null;
    }

    public boolean isOfflinePlayer(@NotNull String path) {
        return false;
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String path) {
        return null;
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String path, @Nullable ItemStack def) {
        return null;
    }

    public boolean isItemStack(@NotNull String path) {
        return false;
    }

    @Nullable
    public Color getColor(@NotNull String path) {
        return null;
    }

    @Nullable
    public Color getColor(@NotNull String path, @Nullable Color def) {
        return null;
    }

    public boolean isColor(@NotNull String path) {
        return false;
    }

    @Nullable
    public Location getLocation(@NotNull String path) {
        return null;
    }

    @Nullable
    public Location getLocation(@NotNull String path, @Nullable Location def) {
        return null;
    }

    public boolean isLocation(@NotNull String path) {
        return false;
    }

    @Nullable
    public ConfigurationSection getConfigurationSection(@NotNull String path) {
        return null;
    }

    public boolean isConfigurationSection(@NotNull String path) {
        return false;
    }

    @Nullable
    public ConfigurationSection getDefaultSection() {
        return null;
    }

    public void addDefault(@NotNull String path, @Nullable Object value) {
    }
}

