/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.tools;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullCreator {
    private static boolean mutateWithNew = false;
    private static Method metaSetProfileMethod;
    private static Field metaProfileField;

    private SkullCreator() {
    }

    public static ItemStack createSkull() {
        return new ItemStack(Material.PLAYER_HEAD);
    }

    public static ItemStack itemFromName(String name) {
        return SkullCreator.itemWithName(SkullCreator.createSkull(), name);
    }

    public static ItemStack itemFromUrl(String url) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return SkullCreator.itemWithUrl(SkullCreator.createSkull(), url);
    }

    public static ItemStack itemFromBase64(String base64) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return SkullCreator.itemWithBase64(SkullCreator.createSkull(), base64);
    }

    @Deprecated
    public static ItemStack itemWithName(ItemStack item, String name) {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(name, "name");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            meta.setOwner(name);
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUrl(ItemStack item, String url) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(url, "url");
        return SkullCreator.itemWithBase64(item, SkullCreator.urlToBase64(url));
    }

    public static ItemStack itemWithBase64(ItemStack item, String base64) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, ClassNotFoundException {
        SkullCreator.notNull(item, "item");
        SkullCreator.notNull(base64, "base64");
        if (!(item.getItemMeta() instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (mutateWithNew || !SkullCreator.mutateItemMeta(meta, base64)) {
            SkullCreator.mutateNewItemMeta(meta, base64);
            mutateWithNew = true;
        }
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Deprecated
    public static void blockWithName(Block block, String name) {
        SkullCreator.notNull(block, "block");
        SkullCreator.notNull(name, "name");
        Skull state = (Skull)block.getState();
        state.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        state.update(false, false);
    }

    private static void notNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + actualUrl + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private static GameProfile makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        GameProfile profile = new GameProfile(id, "Player");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", b64));
        return profile;
    }

    private static boolean mutateItemMeta(SkullMeta meta, String b64) {
        try {
            if (metaSetProfileMethod == null) {
                metaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                metaSetProfileMethod.setAccessible(true);
            }
            metaSetProfileMethod.invoke((Object)meta, SkullCreator.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            try {
                if (metaProfileField == null) {
                    metaProfileField = meta.getClass().getDeclaredField("profile");
                    metaProfileField.setAccessible(true);
                }
                metaProfileField.set(meta, SkullCreator.makeProfile(b64));
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static void mutateNewItemMeta(SkullMeta meta, String b64) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        UUID uuid = UUID.randomUUID();
        Method method = Bukkit.getServer().getClass().getDeclaredMethod("createPlayerProfile", UUID.class, String.class);
        method.setAccessible(true);
        Object playerProfile = method.invoke((Object)Bukkit.getServer(), uuid, uuid.toString().substring(0, 16));
        Method setPropertyMethod = playerProfile.getClass().getDeclaredMethod("setProperty", String.class, Property.class);
        setPropertyMethod.setAccessible(true);
        setPropertyMethod.invoke(playerProfile, "textures", new Property("textures", b64));
        Method setOwnerProfileMethod = meta.getClass().getMethod("setOwnerProfile", Class.forName("org.bukkit.profile.PlayerProfile"));
        setOwnerProfileMethod.setAccessible(true);
        setOwnerProfileMethod.invoke((Object)meta, playerProfile);
    }
}

