/*
 * Decompiled with CFR 0.152.
 */
package com.jodexindustries.donatecase.spigot.tools;

import com.jodexindustries.donatecase.api.armorstand.ArmorStandCreator;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseGuiWrapper;
import com.jodexindustries.donatecase.api.data.casedata.gui.CaseInventory;
import com.jodexindustries.donatecase.api.data.storage.CaseLocation;
import com.jodexindustries.donatecase.api.tools.DCTools;
import com.jodexindustries.donatecase.spigot.BukkitBackend;
import com.jodexindustries.donatecase.spigot.api.armorstand.EntityArmorStandCreator;
import com.jodexindustries.donatecase.spigot.api.armorstand.PacketArmorStandCreator;
import com.jodexindustries.donatecase.spigot.api.platform.BukkitInventory;
import com.jodexindustries.donatecase.spigot.tools.BukkitUtils;
import com.jodexindustries.donatecase.spigot.tools.DCToolsBukkit;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ToolsImpl
extends DCToolsBukkit {
    private final BukkitBackend backend;

    public ToolsImpl(BukkitBackend backend) {
        this.backend = backend;
    }

    @Override
    public CaseInventory createInventory(CaseGuiWrapper wrapper, int size, @Nullable String title) {
        return new BukkitInventory(wrapper, size, title);
    }

    @Override
    public ArmorStandCreator createArmorStand(UUID animationId, CaseLocation location) {
        if (this.backend.getPacketEventsSupport() != null && this.backend.getPacketEventsSupport().isUsePackets()) {
            return new PacketArmorStandCreator(animationId, location);
        }
        return new EntityArmorStandCreator(animationId, BukkitUtils.toBukkit(location));
    }

    @Override
    public Object loadCaseItem(String id) {
        if (id == null) {
            return null;
        }
        Material material = Material.getMaterial((String)id);
        if (material == null) {
            return DCTools.getItemFromManager(id);
        }
        return new ItemStack(material);
    }
}

