/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;

public record ToolMaterialWrapper(TagKey<Block> incorrectBlocksForDrops, int uses, float speed, float attackDamageBonus, int enchantmentValue, TagKey<Item> repairItems, int weaponLevel, int speedLevel) implements Tier
{
    private final TagKey<Item> repairItems;
    public static Codec<Tier> TOOL_MATERIAL_CODEC = Codec.STRING.validate(s -> Defaulted.baseTiers.containsKey(s) ? DataResult.success((Object)s) : DataResult.error(() -> "Given base tier does not exist!")).xmap(s -> (Tier)Defaulted.baseTiers.get((Object)s.toLowerCase()), arg_0 -> Defaulted.baseTiers.inverse().get(arg_0));
    public static MapCodec<ToolMaterialWrapper> BASE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("weapon_level").forGetter(ToolMaterialWrapper::weaponLevel), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("speed_level").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.speedLevel())), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("enchant_level").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.enchantmentValue())), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("uses").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.uses())), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("attack_damage_bonus").forGetter(toolMaterialWrapper -> Optional.of(Float.valueOf(toolMaterialWrapper.attackDamageBonus()))), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("mining_speed").forGetter(toolMaterialWrapper -> Optional.of(Float.valueOf(toolMaterialWrapper.speed()))), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("repair_items").forGetter(toolMaterialWrapper -> Optional.ofNullable(toolMaterialWrapper.repairItems())), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("incorrect_blocks").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.incorrectBlocksForDrops())), (App)TOOL_MATERIAL_CODEC.fieldOf("base_tier").forGetter(ToolMaterialWrapper::asTier)).apply((Applicative)instance, ToolMaterialWrapper::create));
    public static MapCodec<ToolMaterialWrapper> FULL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("weapon_level").forGetter(ToolMaterialWrapper::weaponLevel), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("speed_level").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.speedLevel())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("enchant_level").forGetter(ToolMaterialWrapper::enchantmentValue), (App)ExtraCodecs.POSITIVE_INT.fieldOf("uses").forGetter(ToolMaterialWrapper::uses), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("attack_damage_bonus").forGetter(ToolMaterialWrapper::attackDamageBonus), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("mining_speed").forGetter(ToolMaterialWrapper::speed), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("repair_items").forGetter(ToolMaterialWrapper::repairItems), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("incorrect_blocks").forGetter(ToolMaterialWrapper::incorrectBlocksForDrops)).apply((Applicative)instance, ToolMaterialWrapper::create));
    public static MapCodec<ToolMaterialWrapper> CODEC = Codec.mapEither(FULL_CODEC, BASE_CODEC).xmap(Either::unwrap, Either::left);

    public ToolMaterialWrapper(Tier tier, int weaponLevel, int speedLevel) {
        this((TagKey<Block>)tier.getIncorrectBlocksForDrops(), tier.getUses(), tier.getSpeed(), tier.getAttackDamageBonus(), tier.getEnchantmentValue(), null, weaponLevel, speedLevel);
    }

    public Tier asTier() {
        return this;
    }

    public static ToolMaterialWrapper create(Integer weaponLevel, Optional<Integer> speedLevel, Optional<Integer> enchantLevel, Optional<Integer> uses, Optional<Float> damage, Optional<Float> speed, Optional<TagKey<Item>> repairItems, Optional<TagKey<Block>> incorrect, Tier baseTier) {
        return ToolMaterialWrapper.create(weaponLevel, speedLevel, enchantLevel.orElse(baseTier.getEnchantmentValue()), uses.orElse(baseTier.getUses()), damage.orElse(Float.valueOf(baseTier.getAttackDamageBonus())).floatValue(), speed.orElse(Float.valueOf(baseTier.getSpeed())).floatValue(), (TagKey<Item>)((TagKey)repairItems.orElse(null)), incorrect.orElse((TagKey<Block>)baseTier.getIncorrectBlocksForDrops()));
    }

    public static ToolMaterialWrapper create(int weaponLevel, Optional<Integer> speedLevel, int enchantLevel, int uses, float damage, float speed, TagKey<Item> repairItems, TagKey<Block> incorrect) {
        return new ToolMaterialWrapper(incorrect, uses, speed, damage, enchantLevel, repairItems, weaponLevel, speedLevel.orElse(weaponLevel));
    }

    public int getUses() {
        return this.uses();
    }

    public float getSpeed() {
        return this.speed();
    }

    public float getAttackDamageBonus() {
        return this.attackDamageBonus();
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops();
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue();
    }

    public Ingredient getRepairIngredient() {
        return Ingredient.of(this.repairItems());
    }

    public TagKey<Item> repairItems() {
        if (this.repairItems == null) {
            return ItemTags.PLANKS;
        }
        return this.repairItems;
    }
}

