/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.DefaultedExpectPlatform;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.ToolMaterialWrapper;
import net.atlas.defaulted.component.backport.Enchantable;
import net.atlas.defaulted.component.backport.Repairable;
import net.atlas.defaulted.component.generators.TierComponents;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;

public record ModifyTierStatsGenerator(List<TierComponents> components, Optional<TagKey<Block>> toolMineable, Optional<Float> damageFactor) implements PatchGenerator
{
    public static final MapCodec<ModifyTierStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TierComponents.CODEC.listOf().fieldOf("components").forGetter(ModifyTierStatsGenerator::components), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("mineable_blocks").forGetter(ModifyTierStatsGenerator::toolMineable), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("max_damage_factor").forGetter(ModifyTierStatsGenerator::damageFactor)).apply((Applicative)instance, ModifyTierStatsGenerator::new));

    @Override
    public void patchDataComponentMap(Item item, PatchedDataComponentMap patchedDataComponentMap) {
        ToolMaterialWrapper tier = item.defaulted$getToolMaterial();
        if (tier != null) {
            if (this.components.contains((Object)TierComponents.DURABILITY)) {
                int maxDamage = tier.uses();
                if (this.damageFactor.isPresent()) {
                    maxDamage = Math.round((float)maxDamage * this.damageFactor.get().floatValue());
                }
                Defaulted.setDurability(maxDamage, patchedDataComponentMap);
            }
            if (this.components.contains((Object)TierComponents.ENCHANTABLE)) {
                item.defaulted$set(DefaultedExpectPlatform.getEnchantable(), (Object)new Enchantable(tier.getEnchantmentValue()));
            }
            if (this.components.contains((Object)TierComponents.REPAIRABLE)) {
                item.defaulted$set(DefaultedExpectPlatform.getRepairable(), (Object)new Repairable((Either<HolderSet<Item>, TagKey<Item>>)Either.right(tier.repairItems())));
            }
            if (this.components.contains((Object)TierComponents.TOOL)) {
                if (this.toolMineable.isEmpty()) {
                    LogManager.getLogger((String)"Defaulted").warn("Attempted to update tool component for tiered item " + String.valueOf(item.builtInRegistryHolder()) + " but mineable tag is not present!");
                    return;
                }
                patchedDataComponentMap.set(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.deniesDrops(tier.incorrectBlocksForDrops()), Tool.Rule.minesAndDrops(this.toolMineable.get(), (float)tier.speed())), 1.0f, 1));
            }
        }
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }
}

