/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.ItemPatches;
import net.atlas.defaulted.mixin.ItemAccessor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class DefaultComponentPatchesManager
extends SimpleJsonResourceReloadListener<ItemPatches> {
    public static List<ItemPatches> CLIENT_CACHED = null;
    private static DefaultComponentPatchesManager INSTANCE;
    private List<ItemPatches> cached = null;
    private Map<ResourceLocation, ItemPatches> intermediary = new HashMap<ResourceLocation, ItemPatches>();

    public DefaultComponentPatchesManager(HolderLookup.Provider arg) {
        super(arg, ItemPatches.DIRECT_CODEC, Defaulted.ITEM_PATCHES_TYPE);
        INSTANCE = this;
    }

    public void patch() {
        Defaulted.patchItemComponents(this.cached);
        Defaulted.EXECUTE_ON_RELOAD.forEach(collectionConsumer -> collectionConsumer.accept(this.cached));
    }

    protected Map<ResourceLocation, ItemPatches> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DefaultComponentPatchesManager.clear();
        return super.prepare(resourceManager, profilerFiller);
    }

    protected void apply(Map<ResourceLocation, ItemPatches> patches, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.intermediary = patches;
    }

    public static DefaultComponentPatchesManager getInstance() {
        return INSTANCE;
    }

    public static List<ItemPatches> getCached() {
        if (INSTANCE == null) {
            return null;
        }
        INSTANCE.load();
        return DefaultComponentPatchesManager.INSTANCE.cached;
    }

    public void load() {
        if (this.cached == null) {
            this.cached = this.intermediary.entrySet().stream().map(entry -> new ItemPatchesEntry((ResourceLocation)entry.getKey(), (ItemPatches)entry.getValue())).sorted(Comparator.naturalOrder()).map(ItemPatchesEntry::itemPatches).toList();
            this.patch();
        }
    }

    public static void clear() {
        if (INSTANCE != null) {
            DefaultComponentPatchesManager.INSTANCE.cached = null;
        }
        if (CLIENT_CACHED != null) {
            CLIENT_CACHED = null;
        }
    }

    public static void clearClient() {
        DefaultComponentPatchesManager.clear();
        Defaulted.originalComponents.forEach((itemHolder, components) -> ((ItemAccessor)itemHolder.value()).setComponents((DataComponentMap)components));
    }

    public static void loadClientCache(List<ItemPatches> cached) {
        CLIENT_CACHED = cached;
        Defaulted.patchItemComponents(cached);
    }

    public static void setClientCache() {
        CLIENT_CACHED = DefaultComponentPatchesManager.getCached();
    }

    public record ItemPatchesEntry(ResourceLocation id, ItemPatches itemPatches) implements Comparable<ItemPatchesEntry>
    {
        @Override
        public int compareTo(ItemPatchesEntry other) {
            int priority = this.itemPatches.compareTo(other.itemPatches);
            return priority == 0 ? this.id.compareTo(other.id) : priority;
        }
    }
}

