/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.lang.reflect.Field;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.DefaultedExpectPlatform;
import net.atlas.defaulted.extension.ItemStackExtensions;
import net.atlas.defaulted.mixin.PatchedDataComponentMapAccessor;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements ItemStackExtensions {
    @Mutable
    @Shadow
    @Final
    PatchedDataComponentMap components;

    @Shadow
    public abstract boolean isEmpty();

    @Shadow
    public abstract DataComponentPatch getComponentsPatch();

    @Shadow
    public abstract DataComponentMap getPrototype();

    @WrapMethod(method={"createOptionalStreamCodec(Lnet/minecraft/network/codec/StreamCodec;)Lnet/minecraft/network/codec/StreamCodec;"})
    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> wrapCodec(StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> streamCodec, Operation<StreamCodec<RegistryFriendlyByteBuf, ItemStack>> original) {
        StreamCodec result = (StreamCodec)original.call(new Object[]{streamCodec});
        return ItemStackMixin.defaulted$wrapStreamCodec((StreamCodec<RegistryFriendlyByteBuf, ItemStack>)result);
    }

    @Unique
    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> defaulted$wrapStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> original) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @NotNull
            public ItemStack decode(RegistryFriendlyByteBuf buffer) {
                return (ItemStack)original.decode((Object)buffer);
            }

            public void encode(RegistryFriendlyByteBuf buffer, ItemStack stack) {
                DataComponentMap prototype;
                if (DefaultedExpectPlatform.isOnClientNetworkingThread()) {
                    original.encode((Object)buffer, (Object)stack);
                    return;
                }
                ItemStack newStack = stack.copy();
                if (!stack.isEmpty() && (prototype = ((PatchedDataComponentMapAccessor)PatchedDataComponentMapAccessor.class.cast(stack.getComponents())).getPrototype()) instanceof PatchedDataComponentMap) {
                    PatchedDataComponentMap prototypeDataComponentMap = (PatchedDataComponentMap)prototype;
                    DataComponentMap dataComponentMap = newStack.getComponents();
                    if (dataComponentMap instanceof PatchedDataComponentMap) {
                        PatchedDataComponentMap patchedDataComponentMap = (PatchedDataComponentMap)dataComponentMap;
                        patchedDataComponentMap.restorePatch(prototypeDataComponentMap.asPatch());
                        patchedDataComponentMap.applyPatch(stack.getComponentsPatch());
                    }
                }
                original.encode((Object)buffer, (Object)newStack);
            }
        };
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V"}, at={@At(value="RETURN")})
    public void appendStack(ItemLike itemLike, int count, PatchedDataComponentMap patchedDataComponentMap, CallbackInfo ci) {
        Defaulted.ALL_STACKS.add((ItemStack)ItemStack.class.cast(this));
    }

    @Override
    public void defaulted$updatePrototype() {
        if (!this.isEmpty()) {
            DataComponentMap prototype = ((PatchedDataComponentMapAccessor)PatchedDataComponentMapAccessor.class.cast(this.components)).getPrototype();
            DataComponentMap newPrototype = this.getPrototype();
            if (Defaulted.hasOwo) {
                newPrototype = this.defaulted$wrapAsDerivedComponentMap(newPrototype);
            }
            if (prototype.equals((Object)newPrototype)) {
                return;
            }
            PatchedDataComponentMap newMap = new PatchedDataComponentMap(newPrototype);
            newMap.applyPatch(this.getComponentsPatch());
            this.components = newMap;
        }
    }

    @Unique
    private DataComponentMap defaulted$wrapAsDerivedComponentMap(DataComponentMap prototype) {
        try {
            Field field = ItemStack.class.getDeclaredField("owo$derivedMap");
            DataComponentMap derived = DefaultedExpectPlatform.createDerivedMap((ItemStack)ItemStack.class.cast(this), prototype);
            field.set(this, derived);
            return derived;
        }
        catch (Exception e) {
            Defaulted.LOGGER.error("Failed to wrap as a DerivedComponentMap: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

