/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.DefaultedExpectPlatform;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.ToolMaterialWrapper;
import net.atlas.defaulted.component.backport.Enchantable;
import net.atlas.defaulted.component.backport.Repairable;
import net.atlas.defaulted.component.generators.TierComponents;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import net.minecraft.class_9424;
import org.apache.logging.log4j.LogManager;

public record ModifyTierStatsGenerator(List<TierComponents> components, Optional<class_6862<class_2248>> toolMineable, Optional<Float> damageFactor) implements PatchGenerator
{
    public static final MapCodec<ModifyTierStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TierComponents.CODEC.listOf().fieldOf("components").forGetter(ModifyTierStatsGenerator::components), (App)class_6862.method_40090((class_5321)class_7924.field_41254).optionalFieldOf("mineable_blocks").forGetter(ModifyTierStatsGenerator::toolMineable), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("max_damage_factor").forGetter(ModifyTierStatsGenerator::damageFactor)).apply((Applicative)instance, ModifyTierStatsGenerator::new));

    @Override
    public void patchDataComponentMap(class_1792 item, class_9335 patchedDataComponentMap) {
        ToolMaterialWrapper tier = item.defaulted$getToolMaterial();
        if (tier != null) {
            if (this.components.contains((Object)TierComponents.DURABILITY)) {
                int maxDamage = tier.uses();
                if (this.damageFactor.isPresent()) {
                    maxDamage = Math.round((float)maxDamage * this.damageFactor.get().floatValue());
                }
                Defaulted.setDurability(maxDamage, patchedDataComponentMap);
            }
            if (this.components.contains((Object)TierComponents.ENCHANTABLE)) {
                item.defaulted$set(DefaultedExpectPlatform.getEnchantable(), (Object)new Enchantable(tier.method_8026()));
            }
            if (this.components.contains((Object)TierComponents.REPAIRABLE)) {
                item.defaulted$set(DefaultedExpectPlatform.getRepairable(), (Object)new Repairable((Either<class_6885<class_1792>, class_6862<class_1792>>)Either.right(tier.repairItems())));
            }
            if (this.components.contains((Object)TierComponents.TOOL)) {
                if (this.toolMineable.isEmpty()) {
                    LogManager.getLogger((String)"Defaulted").warn("Attempted to update tool component for tiered item " + String.valueOf(item.method_40131()) + " but mineable tag is not present!");
                    return;
                }
                patchedDataComponentMap.method_57938(class_9334.field_50077, (Object)new class_9424(List.of(class_9424.class_9425.method_58427(tier.incorrectBlocksForDrops()), class_9424.class_9425.method_58428(this.toolMineable.get(), (float)tier.speed())), 1.0f, 1));
            }
        }
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }
}

