/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.ToolMaterialWrapper;
import net.atlas.defaulted.component.generators.WeaponLevelBasedValue;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.class_9335;

public record WeaponStatsGenerator(List<WeaponLevelBasedValue> damage, List<WeaponLevelBasedValue> speed, Optional<class_2960> damageIdOverride, Optional<class_2960> speedIdOverride, List<class_9285.class_9287> additionalModifiers, boolean tieredDamage, boolean persistPrevious) implements PatchGenerator
{
    public static final MapCodec<WeaponStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_damage", Collections.emptyList()).forGetter(WeaponStatsGenerator::damage), (App)WeaponLevelBasedValue.CODEC.optionalFieldOf("attack_speed", Collections.emptyList()).forGetter(WeaponStatsGenerator::speed), (App)class_2960.field_25139.optionalFieldOf("damage_id_override").forGetter(WeaponStatsGenerator::damageIdOverride), (App)class_2960.field_25139.optionalFieldOf("speed_id_override").forGetter(WeaponStatsGenerator::speedIdOverride), (App)class_9285.class_9287.field_49332.listOf().optionalFieldOf("additional_modifiers", Collections.emptyList()).forGetter(WeaponStatsGenerator::additionalModifiers), (App)Codec.BOOL.optionalFieldOf("apply_tier_to_damage", (Object)true).forGetter(WeaponStatsGenerator::tieredDamage), (App)Codec.BOOL.fieldOf("persist_previous").forGetter(WeaponStatsGenerator::persistPrevious)).apply((Applicative)instance, WeaponStatsGenerator::new));

    @Override
    public void patchDataComponentMap(class_1792 item, class_9335 patchedDataComponentMap) {
        class_9285 oldModifiers = (class_9285)patchedDataComponentMap.method_58694(class_9334.field_49636);
        ToolMaterialWrapper toolMaterialWrapper = item.defaulted$getToolMaterial();
        if (toolMaterialWrapper == null) {
            toolMaterialWrapper = Defaulted.DEFAULT_WRAPPER;
        }
        class_9285.class_9286 builder = class_9285.method_57480();
        class_2960 damageID = this.damageIdOverride.orElse(class_1792.field_8006);
        class_2960 speedID = this.speedIdOverride.orElse(class_1792.field_8001);
        class_1322 attackDamage = null;
        boolean hasDamage = false;
        if (!this.damage.isEmpty()) {
            hasDamage = true;
            attackDamage = new class_1322(damageID, this.getTierModifier(toolMaterialWrapper, true), class_1322.class_1323.field_6328);
        }
        class_1322 attackSpeed = null;
        boolean hasSpeed = false;
        if (!this.speed.isEmpty()) {
            hasSpeed = true;
            attackSpeed = new class_1322(speedID, this.getTierModifier(toolMaterialWrapper, false), class_1322.class_1323.field_6328);
        }
        if (!hasDamage && !hasSpeed) {
            return;
        }
        for (class_9285.class_9287 entry : this.additionalModifiers) {
            if (hasDamage && entry.method_60767(class_5134.field_23721, damageID) || hasSpeed && entry.method_60767(class_5134.field_23723, speedID)) continue;
            builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
        }
        if (this.persistPrevious && oldModifiers != null) {
            for (class_9285.class_9287 entry : oldModifiers.comp_2393()) {
                if (hasDamage && entry.method_60767(class_5134.field_23721, damageID) || hasSpeed && entry.method_60767(class_5134.field_23723, speedID)) continue;
                builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
            }
        }
        if (hasDamage) {
            builder.method_57487(class_5134.field_23721, attackDamage, class_9274.field_49217);
        }
        if (hasSpeed) {
            builder.method_57487(class_5134.field_23723, attackSpeed, class_9274.field_49217);
        }
        patchedDataComponentMap.method_57938(class_9334.field_49636, (Object)builder.method_57486());
    }

    private double getTierModifier(ToolMaterialWrapper tier, boolean forDamage) {
        if (forDamage) {
            for (WeaponLevelBasedValue value : this.damage) {
                if (value instanceof WeaponLevelBasedValue.Unconditional) {
                    WeaponLevelBasedValue.Unconditional unconditional = (WeaponLevelBasedValue.Unconditional)value;
                    return unconditional.value() + (this.tieredDamage ? tier.attackDamageBonus() : 0.0f);
                }
                Float res = value.getResult(tier.weaponLevel(), this.tieredDamage);
                if (res == null) continue;
                return res.doubleValue();
            }
        } else {
            for (WeaponLevelBasedValue value : this.speed) {
                Float res = value.getResult(tier.weaponLevel(), true);
                if (res == null) continue;
                return res.doubleValue();
            }
        }
        return 0.0;
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }
}

