/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.atlas.defaulted.component.PatchGenerator;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record AttributeModifiersGenerator(ItemAttributeModifiers toAdd, List<RemovalEntry> toRemove) implements PatchGenerator
{
    public static final MapCodec<AttributeModifiersGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemAttributeModifiers.CODEC.fieldOf("to_add").forGetter(AttributeModifiersGenerator::toAdd), (App)RemovalEntry.CODEC.listOf().fieldOf("to_remove").forGetter(AttributeModifiersGenerator::toRemove)).apply((Applicative)instance, AttributeModifiersGenerator::new));

    @Override
    public void patchDataComponentMap(Item item, PatchedDataComponentMap patchedDataComponentMap) {
        ItemAttributeModifiers base = (ItemAttributeModifiers)patchedDataComponentMap.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        block0: for (ItemAttributeModifiers.Entry entry : base.modifiers()) {
            for (RemovalEntry removalEntry : this.toRemove) {
                if (!removalEntry.matches((Holder<Attribute>)entry.attribute(), entry.modifier().id())) continue;
                continue block0;
            }
            for (ItemAttributeModifiers.Entry added : this.toAdd.modifiers()) {
                if (!added.matches(entry.attribute(), entry.modifier().id())) continue;
                continue block0;
            }
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        for (ItemAttributeModifiers.Entry entry : this.toAdd.modifiers()) {
            builder.add(entry.attribute(), entry.modifier(), entry.slot());
        }
        patchedDataComponentMap.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)builder.build());
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }

    public record RemovalEntry(Holder<Attribute> attribute, ResourceLocation id) {
        public static final Codec<RemovalEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Attribute.CODEC.fieldOf("type").forGetter(RemovalEntry::attribute), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(RemovalEntry::id)).apply((Applicative)instance, RemovalEntry::new));

        public boolean matches(Holder<Attribute> holder, ResourceLocation resourceLocation) {
            return holder.equals(this.attribute) && this.id.equals((Object)resourceLocation);
        }
    }
}

