/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public interface WeaponLevelBasedValue {
    public static final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends WeaponLevelBasedValue>> ID_MAPPER = new ExtraCodecs.LateBoundIdMapper();
    public static final Codec<WeaponLevelBasedValue> BASE_CODEC = ID_MAPPER.codec(ResourceLocation.CODEC).dispatch(WeaponLevelBasedValue::codec, mapCodec -> mapCodec);
    public static final Codec<WeaponLevelBasedValue> CODEC = Codec.withAlternative(BASE_CODEC, (Codec)Codec.FLOAT.xmap(Unconditional::new, Unconditional::value));

    public static void bootstrap() {
        LevelCondition.bootstrap();
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"unconditional"), Unconditional.CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"lookup"), Lookup.CODEC);
        ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"linear"), Linear.CODEC);
    }

    public Float getResult(int var1, float var2, boolean var3);

    default public Float getResult(int weaponLevel, boolean applyTier) {
        return this.getResult(weaponLevel, 0.0f, applyTier);
    }

    public MapCodec<? extends WeaponLevelBasedValue> codec();

    public static interface LevelCondition {
        public static final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends LevelCondition>> ID_MAPPER = new ExtraCodecs.LateBoundIdMapper();
        public static final Codec<LevelCondition> BASE_CODEC = ID_MAPPER.codec(ResourceLocation.CODEC).dispatch(LevelCondition::codec, mapCodec -> mapCodec);
        public static final Codec<LevelCondition> CODEC = Codec.withAlternative(BASE_CODEC, (Codec)Codec.INT.xmap(i -> new ClampedCondition((int)i, (int)i), ClampedCondition::min));

        public static void bootstrap() {
            ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"clamped"), ClampedCondition.CODEC);
            ID_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"list"), ListCondition.CODEC);
        }

        public boolean matches(int var1);

        public MapCodec<? extends LevelCondition> codec();
    }

    public record Unconditional(float value) implements WeaponLevelBasedValue
    {
        public static final MapCodec<Unconditional> CODEC = Codec.FLOAT.xmap(Unconditional::new, Unconditional::value).fieldOf("value");

        @Override
        public Float getResult(int weaponLevel, float addedValue, boolean applyTier) {
            return Float.valueOf(this.value);
        }

        @Override
        public MapCodec<? extends WeaponLevelBasedValue> codec() {
            return CODEC;
        }
    }

    public record Lookup(List<MatchingLevel> values, Float fallback) implements WeaponLevelBasedValue
    {
        public static final MapCodec<Lookup> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MatchingLevel.CODEC.listOf().fieldOf("values").forGetter(Lookup::values), (App)Codec.FLOAT.fieldOf("fallback").forGetter(Lookup::fallback)).apply((Applicative)instance, Lookup::new));

        @Override
        public Float getResult(int weaponLevel, float addedValue, boolean applyTier) {
            for (MatchingLevel value : this.values) {
                Float res = value.getResult(weaponLevel, addedValue, applyTier);
                if (res == null) continue;
                return value.getResult(weaponLevel, addedValue, applyTier);
            }
            return Float.valueOf(this.fallback.floatValue() + (applyTier ? addedValue : 0.0f));
        }

        @Override
        public MapCodec<? extends WeaponLevelBasedValue> codec() {
            return CODEC;
        }
    }

    public record Linear(WeaponLevelBasedValue base, WeaponLevelBasedValue perLevelAboveFirst) implements WeaponLevelBasedValue
    {
        public static final MapCodec<Linear> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("base").forGetter(Linear::base), (App)CODEC.fieldOf("per_level_above_first").forGetter(Linear::perLevelAboveFirst)).apply((Applicative)instance, Linear::new));

        @Override
        public Float getResult(int weaponLevel, float addedValue, boolean applyTier) {
            return Float.valueOf(this.base.getResult(weaponLevel, addedValue, applyTier).floatValue() + (float)weaponLevel * this.perLevelAboveFirst.getResult(weaponLevel, addedValue, applyTier).floatValue());
        }

        @Override
        public MapCodec<? extends WeaponLevelBasedValue> codec() {
            return CODEC;
        }
    }

    public record MatchingLevel(WeaponLevelBasedValue value, LevelCondition levelCondition) {
        public static final Codec<MatchingLevel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC.fieldOf("value").forGetter(MatchingLevel::value), (App)LevelCondition.CODEC.fieldOf("condition").forGetter(MatchingLevel::levelCondition)).apply((Applicative)instance, MatchingLevel::new));

        public Float getResult(int weaponLevel, float addedValue, boolean applyTier) {
            return this.levelCondition.matches(weaponLevel) || !applyTier ? this.value.getResult(weaponLevel, addedValue, applyTier) : null;
        }
    }

    public record ListCondition(IntStream values) implements LevelCondition
    {
        public static final MapCodec<ListCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT_STREAM.fieldOf("values").forGetter(ListCondition::values)).apply((Applicative)instance, ListCondition::new));

        @Override
        public boolean matches(int value) {
            return this.values.anyMatch(val -> val == value);
        }

        @Override
        public MapCodec<? extends LevelCondition> codec() {
            return CODEC;
        }
    }

    public record ClampedCondition(int min, int max) implements LevelCondition
    {
        public static final MapCodec<ClampedCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("min").forGetter(ClampedCondition::min), (App)Codec.INT.fieldOf("max").forGetter(ClampedCondition::max)).apply((Applicative)instance, ClampedCondition::new));

        @Override
        public boolean matches(int value) {
            return value >= this.min && value <= this.max;
        }

        @Override
        public MapCodec<? extends LevelCondition> codec() {
            return CODEC;
        }
    }
}

