/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.block.Block;

public record ToolMaterialWrapper(ToolMaterial toolMaterial, int weaponLevel, int speedLevel) {
    public static Codec<ToolMaterial> TOOL_MATERIAL_CODEC = Codec.STRING.validate(s -> Defaulted.baseTiers.containsKey(s) ? DataResult.success((Object)s) : DataResult.error(() -> "Given base tier does not exist!")).xmap(s -> (ToolMaterial)Defaulted.baseTiers.get((Object)s.toLowerCase()), arg_0 -> Defaulted.baseTiers.inverse().get(arg_0));
    public static MapCodec<ToolMaterialWrapper> BASE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("weapon_level").forGetter(ToolMaterialWrapper::weaponLevel), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("speed_level").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.speedLevel())), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("enchant_level").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.enchantmentValue())), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("uses").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.durability())), (App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("attack_damage_bonus").forGetter(toolMaterialWrapper -> Optional.of(Float.valueOf(toolMaterialWrapper.attackDamageBonus()))), (App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("mining_speed").forGetter(toolMaterialWrapper -> Optional.of(Float.valueOf(toolMaterialWrapper.speed()))), (App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("repair_items").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.repairItems())), (App)TagKey.codec((ResourceKey)Registries.BLOCK).optionalFieldOf("incorrect_blocks").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.incorrectBlocksForDrops())), (App)TOOL_MATERIAL_CODEC.fieldOf("base_tier").forGetter(ToolMaterialWrapper::toolMaterial)).apply((Applicative)instance, ToolMaterialWrapper::create));
    public static MapCodec<ToolMaterialWrapper> FULL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("weapon_level").forGetter(ToolMaterialWrapper::weaponLevel), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("speed_level").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.speedLevel())), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("enchant_level").forGetter(ToolMaterialWrapper::enchantmentValue), (App)ExtraCodecs.POSITIVE_INT.fieldOf("uses").forGetter(ToolMaterialWrapper::durability), (App)ExtraCodecs.NON_NEGATIVE_FLOAT.fieldOf("attack_damage_bonus").forGetter(ToolMaterialWrapper::attackDamageBonus), (App)ExtraCodecs.NON_NEGATIVE_FLOAT.fieldOf("mining_speed").forGetter(ToolMaterialWrapper::speed), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("repair_items").forGetter(ToolMaterialWrapper::repairItems), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("incorrect_blocks").forGetter(ToolMaterialWrapper::incorrectBlocksForDrops)).apply((Applicative)instance, ToolMaterialWrapper::create));
    public static MapCodec<ToolMaterialWrapper> CODEC = Codec.mapEither(FULL_CODEC, BASE_CODEC).xmap(Either::unwrap, Either::left);

    public static ToolMaterialWrapper create(Integer weaponLevel, Optional<Integer> speedLevel, Optional<Integer> enchantLevel, Optional<Integer> uses, Optional<Float> damage, Optional<Float> speed, Optional<TagKey<Item>> repairItems, Optional<TagKey<Block>> incorrect, ToolMaterial baseTier) {
        return ToolMaterialWrapper.create(weaponLevel, speedLevel, enchantLevel.orElse(baseTier.enchantmentValue()), uses.orElse(baseTier.durability()), damage.orElse(Float.valueOf(baseTier.attackDamageBonus())).floatValue(), speed.orElse(Float.valueOf(baseTier.speed())).floatValue(), repairItems.orElse((TagKey<Item>)baseTier.repairItems()), incorrect.orElse((TagKey<Block>)baseTier.incorrectBlocksForDrops()));
    }

    public static ToolMaterialWrapper create(int weaponLevel, Optional<Integer> speedLevel, int enchantLevel, int uses, float damage, float speed, TagKey<Item> repairItems, TagKey<Block> incorrect) {
        return new ToolMaterialWrapper(new ToolMaterial(incorrect, uses, speed, damage, enchantLevel, repairItems), weaponLevel, speedLevel.orElse(weaponLevel));
    }

    public TagKey<Block> incorrectBlocksForDrops() {
        return this.toolMaterial.incorrectBlocksForDrops();
    }

    public int durability() {
        return this.toolMaterial.durability();
    }

    public float speed() {
        return this.toolMaterial.speed();
    }

    public float attackDamageBonus() {
        return this.toolMaterial.attackDamageBonus();
    }

    public int enchantmentValue() {
        return this.toolMaterial.enchantmentValue();
    }

    public TagKey<Item> repairItems() {
        return this.toolMaterial.repairItems();
    }
}

