/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;

public class PatchConditions {
    public static final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends PatchCondition>> CONDITION_MAPPER = new ExtraCodecs.LateBoundIdMapper();
    public static final MapCodec<PatchCondition> MAP_CODEC = CONDITION_MAPPER.codec(ResourceLocation.CODEC).dispatchMap("condition", PatchCondition::codec, mapCodec -> mapCodec);

    public static void bootstrap() {
        CONDITION_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"invert"), InvertCondition.CODEC);
        CONDITION_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"condition_list"), ListCondition.CODEC);
        CONDITION_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"is_item"), ItemIsCondition.CODEC);
        CONDITION_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"in_tag"), ItemHasTagCondition.CODEC);
        CONDITION_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"has_components"), ComponentsPresentCondition.CODEC);
        CONDITION_MAPPER.put((Object)ResourceLocation.withDefaultNamespace((String)"matches_components"), ExactComponentsCondition.CODEC);
    }

    public record InvertCondition(PatchCondition patchCondition) implements PatchCondition
    {
        public static final MapCodec<InvertCondition> CODEC = MAP_CODEC.codec().fieldOf("inverted").xmap(InvertCondition::new, InvertCondition::patchCondition);

        @Override
        public boolean matches(Item item, PatchedDataComponentMap patchedDataComponentMap) {
            return !this.patchCondition.matches(item, patchedDataComponentMap);
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ListCondition(List<PatchCondition> conditions, boolean allMatch) implements PatchCondition
    {
        public static final MapCodec<ListCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MAP_CODEC.codec().listOf().fieldOf("conditions").forGetter(ListCondition::conditions), (App)Codec.BOOL.fieldOf("all_required").forGetter(ListCondition::allMatch)).apply((Applicative)instance, ListCondition::new));

        @Override
        public boolean matches(Item item, PatchedDataComponentMap patchedDataComponentMap) {
            for (PatchCondition condition : this.conditions) {
                boolean result = condition.matches(item, patchedDataComponentMap);
                if (result == this.allMatch) continue;
                return result;
            }
            return this.allMatch;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return null;
        }
    }

    public record ItemIsCondition(HolderSet<Item> items) implements PatchCondition
    {
        public static final MapCodec<ItemIsCondition> CODEC = ExtraCodecs.nonEmptyHolderSet((Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM)).xmap(ItemIsCondition::new, ItemIsCondition::items).fieldOf("items");

        @Override
        public boolean matches(Item item, PatchedDataComponentMap patchedDataComponentMap) {
            for (Holder itemHolder : this.items) {
                if (!item.builtInRegistryHolder().is(itemHolder)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ItemHasTagCondition(List<TagKey<Item>> tags) implements PatchCondition
    {
        public static final MapCodec<ItemHasTagCondition> CODEC = TagKey.codec((ResourceKey)Registries.ITEM).listOf().xmap(ItemHasTagCondition::new, ItemHasTagCondition::tags).fieldOf("tags");

        @Override
        public boolean matches(Item item, PatchedDataComponentMap patchedDataComponentMap) {
            for (TagKey<Item> itemTag : this.tags) {
                if (!item.builtInRegistryHolder().is(itemTag)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ComponentsPresentCondition(List<DataComponentType<?>> presentComponents, boolean allMatch) implements PatchCondition
    {
        public static final MapCodec<ComponentsPresentCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DataComponentType.CODEC.listOf().fieldOf("components").forGetter(ComponentsPresentCondition::presentComponents), (App)Codec.BOOL.fieldOf("all_required").forGetter(ComponentsPresentCondition::allMatch)).apply((Applicative)instance, ComponentsPresentCondition::new));

        @Override
        public boolean matches(Item item, PatchedDataComponentMap patchedDataComponentMap) {
            for (DataComponentType<?> dataComponentType : this.presentComponents) {
                boolean result = patchedDataComponentMap.has(dataComponentType);
                if (result == this.allMatch) continue;
                return result;
            }
            return this.allMatch;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ExactComponentsCondition(DataComponentMap exactComponents, boolean allMatch) implements PatchCondition
    {
        public static final MapCodec<ExactComponentsCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DataComponentMap.CODEC.fieldOf("components").forGetter(ExactComponentsCondition::exactComponents), (App)Codec.BOOL.fieldOf("all_required").forGetter(ExactComponentsCondition::allMatch)).apply((Applicative)instance, ExactComponentsCondition::new));

        @Override
        public boolean matches(Item item, PatchedDataComponentMap patchedDataComponentMap) {
            for (TypedDataComponent dataComponent : this.exactComponents) {
                TypedDataComponent present = patchedDataComponentMap.getTyped(dataComponent.type());
                boolean result = present == null ? false : Objects.equals(dataComponent.value(), present.value());
                if (result == this.allMatch) continue;
                return result;
            }
            return this.allMatch;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public static interface PatchCondition {
        public boolean matches(Item var1, PatchedDataComponentMap var2);

        public MapCodec<? extends PatchCondition> codec();
    }
}

