/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.extension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.IdentityHashMap;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.HashedPatchMap;
import net.minecraft.network.HashedStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.HashOps;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class WrapHashedStreamCodec
implements StreamCodec<RegistryFriendlyByteBuf, HashedStack.ActualItem> {
    private final StreamCodec<RegistryFriendlyByteBuf, HashedStack.ActualItem> original;
    private DynamicOps<HashCode> registryHashOps;
    private final LoadingCache<TypedDataComponent<?>, Integer> cache = CacheBuilder.newBuilder().maximumSize(256L).build(new CacheLoader<TypedDataComponent<?>, Integer>(){

        public Integer load(TypedDataComponent<?> typedDataComponent) {
            return ((HashCode)typedDataComponent.encodeValue(WrapHashedStreamCodec.this.registryHashOps).getOrThrow(string -> new IllegalArgumentException("Failed to hash " + String.valueOf(typedDataComponent) + ": " + string))).asInt();
        }
    });

    public WrapHashedStreamCodec(StreamCodec<RegistryFriendlyByteBuf, HashedStack.ActualItem> original) {
        this.original = original;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HashedStack.ActualItem decode(RegistryFriendlyByteBuf buffer) {
        this.registryHashOps = buffer.registryAccess().createSerializationContext((DynamicOps)HashOps.CRC32C_INSTANCE);
        HashedStack.ActualItem stack = (HashedStack.ActualItem)this.original.decode((Object)buffer);
        HashedPatchMap components = stack.components();
        DataComponentMap prototype = ((Item)stack.item().value()).components();
        if (prototype instanceof PatchedDataComponentMap) {
            PatchedDataComponentMap prototypeDataComponentMap = (PatchedDataComponentMap)prototype;
            DataComponentPatch.SplitResult splitResult = prototypeDataComponentMap.asPatch().split();
            IdentityHashMap added = new IdentityHashMap(splitResult.added().size());
            added.putAll(components.addedComponents());
            splitResult.added().forEach(typedDataComponent -> {
                if (added.containsKey(typedDataComponent.type()) && ((Integer)added.get(typedDataComponent.type())).equals(this.cache.getUnchecked(typedDataComponent))) {
                    added.remove(typedDataComponent.type());
                }
            });
            HashSet removed = new HashSet(components.removedComponents());
            removed.removeAll(splitResult.removed());
            stack = new HashedStack.ActualItem(stack.item(), stack.count(), new HashedPatchMap(added, removed));
        }
        return stack;
    }

    public void encode(RegistryFriendlyByteBuf buffer, HashedStack.ActualItem stack) {
        this.original.encode((Object)buffer, (Object)stack);
    }
}

