/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.atlas.defaulted.component.ItemPatches;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.ToolMaterialWrapper;
import net.atlas.defaulted.component.generators.WeaponLevelBasedValue;
import net.atlas.defaulted.component.generators.condition.PatchConditions;
import net.atlas.defaulted.extension.ItemStackExtensions;
import net.atlas.defaulted.mixin.ItemAccessor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Defaulted {
    public static boolean hasOwo = false;
    public static final BiMap<String, ToolMaterial> baseTiers = HashBiMap.create();
    public static final ToolMaterialWrapper DEFAULT_WRAPPER = new ToolMaterialWrapper(ToolMaterial.DIAMOND, 3, 3);
    public static final Map<Holder<Item>, DataComponentMap> originalComponents = new HashMap<Holder<Item>, DataComponentMap>();
    public static final String MOD_ID = "defaulted";
    public static final Logger LOGGER = LogManager.getLogger((String)"defaulted");
    public static final ResourceKey<Registry<MapCodec<? extends PatchGenerator>>> PATCH_GENERATOR_TYPE = ResourceKey.createRegistryKey((ResourceLocation)Defaulted.id("patch_generator"));
    public static final ResourceKey<Registry<ItemPatches>> ITEM_PATCHES_TYPE = ResourceKey.createRegistryKey((ResourceLocation)Defaulted.id("default_component_patches"));
    public static final List<Consumer<Collection<ItemPatches>>> EXECUTE_ON_RELOAD = new ArrayList<Consumer<Collection<ItemPatches>>>();
    public static final List<Consumer<Map<ResourceLocation, ItemPatches>>> ADD_DEFAULT_PATCHES = new ArrayList<Consumer<Map<ResourceLocation, ItemPatches>>>();
    public static final Set<ItemStack> ALL_STACKS = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public static void init() {
        baseTiers.put((Object)"wood", (Object)ToolMaterial.WOOD);
        baseTiers.put((Object)"stone", (Object)ToolMaterial.STONE);
        baseTiers.put((Object)"gold", (Object)ToolMaterial.GOLD);
        baseTiers.put((Object)"copper", (Object)ToolMaterial.COPPER);
        baseTiers.put((Object)"iron", (Object)ToolMaterial.IRON);
        baseTiers.put((Object)"diamond", (Object)ToolMaterial.DIAMOND);
        baseTiers.put((Object)"netherite", (Object)ToolMaterial.NETHERITE);
        PatchConditions.bootstrap();
        WeaponLevelBasedValue.bootstrap();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void setDurability(int maxDamage, PatchedDataComponentMap patchedDataComponentMap) {
        patchedDataComponentMap.set(DataComponents.MAX_DAMAGE, (Object)maxDamage);
        patchedDataComponentMap.set(DataComponents.DAMAGE, (Object)0);
        patchedDataComponentMap.set(DataComponents.MAX_STACK_SIZE, (Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patchItemComponents(Iterable<ItemPatches> reg) {
        for (Item item : BuiltInRegistries.ITEM) {
            Holder.Reference itemHolder = item.builtInRegistryHolder();
            DataComponentMap originalPrototype = item.components();
            if (originalComponents.containsKey(itemHolder)) {
                originalPrototype = originalComponents.get(itemHolder);
                ((ItemAccessor)item).setComponents(originalPrototype);
            } else {
                originalComponents.put((Holder<Item>)itemHolder, originalPrototype);
            }
            PatchedDataComponentMap newMap = new PatchedDataComponentMap(originalPrototype);
            reg.forEach(itemPatches -> itemPatches.apply(item, newMap));
            reg.forEach(itemPatches -> itemPatches.applyGenerators(item, newMap));
            if (newMap.asPatch().isEmpty()) continue;
            ((ItemAccessor)item).setComponents((DataComponentMap)newMap);
        }
        Set<ItemStack> set = ALL_STACKS;
        synchronized (set) {
            ALL_STACKS.forEach(ItemStackExtensions::defaulted$updatePrototype);
        }
    }

    public static boolean isOnClientNetworkingThread() {
        return Thread.currentThread().getName().startsWith("Netty") && Thread.currentThread().getName().contains("Client");
    }
}

