/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.atlas.defaulted.component.PatchGenerator;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.BlocksAttacks;

public record BlocksAttacksGenerator(Optional<Float> blockDelaySeconds, Optional<Float> disableCooldownScale, List<BlocksAttacks.DamageReduction> damageReductions, Optional<BlocksAttacks.ItemDamageFunction> itemDamage, Optional<TagKey<DamageType>> bypassedBy, Optional<Holder<SoundEvent>> blockSound, Optional<Holder<SoundEvent>> disableSound, boolean appendReductions) implements PatchGenerator
{
    public static final MapCodec<BlocksAttacksGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("block_delay_seconds").forGetter(BlocksAttacksGenerator::blockDelaySeconds), (App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("disable_cooldown_scale").forGetter(BlocksAttacksGenerator::disableCooldownScale), (App)BlocksAttacks.DamageReduction.CODEC.listOf().optionalFieldOf("damage_reductions", List.of(new BlocksAttacks.DamageReduction(90.0f, Optional.empty(), 0.0f, 1.0f))).forGetter(BlocksAttacksGenerator::damageReductions), (App)BlocksAttacks.ItemDamageFunction.CODEC.optionalFieldOf("item_damage").forGetter(BlocksAttacksGenerator::itemDamage), (App)TagKey.hashedCodec((ResourceKey)Registries.DAMAGE_TYPE).optionalFieldOf("bypassed_by").forGetter(BlocksAttacksGenerator::bypassedBy), (App)SoundEvent.CODEC.optionalFieldOf("block_sound").forGetter(BlocksAttacksGenerator::blockSound), (App)SoundEvent.CODEC.optionalFieldOf("disabled_sound").forGetter(BlocksAttacksGenerator::disableSound), (App)Codec.BOOL.optionalFieldOf("append_reductions", (Object)true).forGetter(BlocksAttacksGenerator::appendReductions)).apply((Applicative)instance, BlocksAttacksGenerator::new));

    @Override
    public void patchDataComponentMap(Item item, PatchedDataComponentMap patchedDataComponentMap) {
        BlocksAttacks original = (BlocksAttacks)patchedDataComponentMap.get(DataComponents.BLOCKS_ATTACKS);
        if (original != null) {
            ArrayList<BlocksAttacks.DamageReduction> combined = new ArrayList<BlocksAttacks.DamageReduction>(this.damageReductions);
            if (this.appendReductions) {
                combined.addAll(original.damageReductions());
            }
            patchedDataComponentMap.set(DataComponents.BLOCKS_ATTACKS, (Object)new BlocksAttacks(this.blockDelaySeconds.orElse(Float.valueOf(original.blockDelaySeconds())).floatValue(), this.disableCooldownScale.orElse(Float.valueOf(original.disableCooldownScale())).floatValue(), combined, this.itemDamage.orElse(original.itemDamage()), this.bypassedBy.or(() -> ((BlocksAttacks)original).bypassedBy()), this.blockSound.or(() -> ((BlocksAttacks)original).blockSound()), this.disableSound.or(() -> ((BlocksAttacks)original).disableSound())));
        } else {
            patchedDataComponentMap.set(DataComponents.BLOCKS_ATTACKS, (Object)new BlocksAttacks(this.blockDelaySeconds.orElse(Float.valueOf(1.0f)).floatValue(), this.disableCooldownScale.orElse(Float.valueOf(1.0f)).floatValue(), this.damageReductions, this.itemDamage.orElse(BlocksAttacks.ItemDamageFunction.DEFAULT), this.bypassedBy, this.blockSound, this.disableSound));
        }
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }
}

