/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9886;

public record ToolMaterialWrapper(class_9886 toolMaterial, int weaponLevel) {
    public static Codec<class_9886> TOOL_MATERIAL_CODEC = Codec.STRING.validate(s -> Defaulted.baseTiers.containsKey(s) ? DataResult.success((Object)s) : DataResult.error(() -> "Given base tier does not exist!")).xmap(s -> (class_9886)Defaulted.baseTiers.get((Object)s.toLowerCase()), arg_0 -> Defaulted.baseTiers.inverse().get(arg_0));
    public static MapCodec<ToolMaterialWrapper> BASE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33441.fieldOf("weapon_level").forGetter(ToolMaterialWrapper::weaponLevel), (App)class_5699.field_33441.optionalFieldOf("enchant_level").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.enchantmentValue())), (App)class_5699.field_33442.optionalFieldOf("uses").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.durability())), (App)class_5699.field_53754.optionalFieldOf("attack_damage_bonus").forGetter(toolMaterialWrapper -> Optional.of(Float.valueOf(toolMaterialWrapper.attackDamageBonus()))), (App)class_5699.field_53754.optionalFieldOf("mining_speed").forGetter(toolMaterialWrapper -> Optional.of(Float.valueOf(toolMaterialWrapper.speed()))), (App)class_6862.method_40090((class_5321)class_7924.field_41197).optionalFieldOf("repair_items").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.repairItems())), (App)class_6862.method_40090((class_5321)class_7924.field_41254).optionalFieldOf("incorrect_blocks").forGetter(toolMaterialWrapper -> Optional.of(toolMaterialWrapper.incorrectBlocksForDrops())), (App)TOOL_MATERIAL_CODEC.fieldOf("base_tier").forGetter(ToolMaterialWrapper::toolMaterial)).apply((Applicative)instance, ToolMaterialWrapper::create));
    public static MapCodec<ToolMaterialWrapper> FULL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33441.fieldOf("weapon_level").forGetter(ToolMaterialWrapper::weaponLevel), (App)class_5699.field_33441.fieldOf("enchant_level").forGetter(ToolMaterialWrapper::enchantmentValue), (App)class_5699.field_33442.fieldOf("uses").forGetter(ToolMaterialWrapper::durability), (App)class_5699.field_53754.fieldOf("attack_damage_bonus").forGetter(ToolMaterialWrapper::attackDamageBonus), (App)class_5699.field_53754.fieldOf("mining_speed").forGetter(ToolMaterialWrapper::speed), (App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("repair_items").forGetter(ToolMaterialWrapper::repairItems), (App)class_6862.method_40090((class_5321)class_7924.field_41254).fieldOf("incorrect_blocks").forGetter(ToolMaterialWrapper::incorrectBlocksForDrops)).apply((Applicative)instance, ToolMaterialWrapper::create));
    public static MapCodec<ToolMaterialWrapper> CODEC = Codec.mapEither(FULL_CODEC, BASE_CODEC).xmap(Either::unwrap, Either::left);

    public static ToolMaterialWrapper create(Integer weaponLevel, Optional<Integer> enchantLevel, Optional<Integer> uses, Optional<Float> damage, Optional<Float> speed, Optional<class_6862<class_1792>> repairItems, Optional<class_6862<class_2248>> incorrect, class_9886 baseTier) {
        return ToolMaterialWrapper.create(weaponLevel, enchantLevel.orElse(baseTier.comp_2934()), uses.orElse(baseTier.comp_2931()), damage.orElse(Float.valueOf(baseTier.comp_2933())).floatValue(), speed.orElse(Float.valueOf(baseTier.comp_2932())).floatValue(), repairItems.orElse((class_6862<class_1792>)baseTier.comp_2935()), incorrect.orElse((class_6862<class_2248>)baseTier.comp_2930()));
    }

    public static ToolMaterialWrapper create(int weaponLevel, int enchantLevel, int uses, float damage, float speed, class_6862<class_1792> repairItems, class_6862<class_2248> incorrect) {
        return new ToolMaterialWrapper(new class_9886(incorrect, uses, speed, damage, enchantLevel, repairItems), weaponLevel);
    }

    public class_6862<class_2248> incorrectBlocksForDrops() {
        return this.toolMaterial.comp_2930();
    }

    public int durability() {
        return this.toolMaterial.comp_2931();
    }

    public float speed() {
        return this.toolMaterial.comp_2932();
    }

    public float attackDamageBonus() {
        return this.toolMaterial.comp_2933();
    }

    public int enchantmentValue() {
        return this.toolMaterial.comp_2934();
    }

    public class_6862<class_1792> repairItems() {
        return this.toolMaterial.comp_2935();
    }
}

