/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9335;
import net.minecraft.class_9336;

public class PatchConditions {
    public static final class_5699.class_10388<class_2960, MapCodec<? extends PatchCondition>> CONDITION_MAPPER = new class_5699.class_10388();
    public static final MapCodec<PatchCondition> MAP_CODEC = CONDITION_MAPPER.method_65323(class_2960.field_25139).dispatchMap("condition", PatchCondition::codec, mapCodec -> mapCodec);

    public static void bootstrap() {
        CONDITION_MAPPER.method_65325((Object)class_2960.method_60656((String)"invert"), InvertCondition.CODEC);
        CONDITION_MAPPER.method_65325((Object)class_2960.method_60656((String)"condition_list"), ListCondition.CODEC);
        CONDITION_MAPPER.method_65325((Object)class_2960.method_60656((String)"is_item"), ItemIsCondition.CODEC);
        CONDITION_MAPPER.method_65325((Object)class_2960.method_60656((String)"in_tag"), ItemHasTagCondition.CODEC);
        CONDITION_MAPPER.method_65325((Object)class_2960.method_60656((String)"has_components"), ComponentsPresentCondition.CODEC);
        CONDITION_MAPPER.method_65325((Object)class_2960.method_60656((String)"matches_components"), ExactComponentsCondition.CODEC);
    }

    public record InvertCondition(PatchCondition patchCondition) implements PatchCondition
    {
        public static final MapCodec<InvertCondition> CODEC = MAP_CODEC.codec().fieldOf("inverted").xmap(InvertCondition::new, InvertCondition::patchCondition);

        @Override
        public boolean matches(class_1792 item, class_9335 patchedDataComponentMap) {
            return !this.patchCondition.matches(item, patchedDataComponentMap);
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ListCondition(List<PatchCondition> conditions, boolean allMatch) implements PatchCondition
    {
        public static final MapCodec<ListCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MAP_CODEC.codec().listOf().fieldOf("conditions").forGetter(ListCondition::conditions), (App)Codec.BOOL.fieldOf("all_required").forGetter(ListCondition::allMatch)).apply((Applicative)instance, ListCondition::new));

        @Override
        public boolean matches(class_1792 item, class_9335 patchedDataComponentMap) {
            for (PatchCondition condition : this.conditions) {
                boolean result = condition.matches(item, patchedDataComponentMap);
                if (result == this.allMatch) continue;
                return result;
            }
            return this.allMatch;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return null;
        }
    }

    public record ItemIsCondition(class_6885<class_1792> items) implements PatchCondition
    {
        public static final MapCodec<ItemIsCondition> CODEC = class_5699.method_40113((Codec)class_6895.method_40340((class_5321)class_7924.field_41197)).xmap(ItemIsCondition::new, ItemIsCondition::items).fieldOf("items");

        @Override
        public boolean matches(class_1792 item, class_9335 patchedDataComponentMap) {
            for (class_6880 itemHolder : this.items) {
                if (!item.method_40131().method_55838(itemHolder)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ItemHasTagCondition(List<class_6862<class_1792>> tags) implements PatchCondition
    {
        public static final MapCodec<ItemHasTagCondition> CODEC = class_6862.method_40090((class_5321)class_7924.field_41197).listOf().xmap(ItemHasTagCondition::new, ItemHasTagCondition::tags).fieldOf("tags");

        @Override
        public boolean matches(class_1792 item, class_9335 patchedDataComponentMap) {
            for (class_6862<class_1792> itemTag : this.tags) {
                if (!item.method_40131().method_40220(itemTag)) continue;
                return true;
            }
            return false;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ComponentsPresentCondition(List<class_9331<?>> presentComponents, boolean allMatch) implements PatchCondition
    {
        public static final MapCodec<ComponentsPresentCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_9331.field_49600.listOf().fieldOf("components").forGetter(ComponentsPresentCondition::presentComponents), (App)Codec.BOOL.fieldOf("all_required").forGetter(ComponentsPresentCondition::allMatch)).apply((Applicative)instance, ComponentsPresentCondition::new));

        @Override
        public boolean matches(class_1792 item, class_9335 patchedDataComponentMap) {
            for (class_9331<?> dataComponentType : this.presentComponents) {
                boolean result = patchedDataComponentMap.method_57832(dataComponentType);
                if (result == this.allMatch) continue;
                return result;
            }
            return this.allMatch;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public record ExactComponentsCondition(class_9323 exactComponents, boolean allMatch) implements PatchCondition
    {
        public static final MapCodec<ExactComponentsCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_9323.field_50234.fieldOf("components").forGetter(ExactComponentsCondition::exactComponents), (App)Codec.BOOL.fieldOf("all_required").forGetter(ExactComponentsCondition::allMatch)).apply((Applicative)instance, ExactComponentsCondition::new));

        @Override
        public boolean matches(class_1792 item, class_9335 patchedDataComponentMap) {
            for (class_9336 dataComponent : this.exactComponents) {
                class_9336 present = patchedDataComponentMap.method_57834(dataComponent.comp_2443());
                boolean result = present == null ? false : Objects.equals(dataComponent.comp_2444(), present.comp_2444());
                if (result == this.allMatch) continue;
                return result;
            }
            return this.allMatch;
        }

        @Override
        public MapCodec<? extends PatchCondition> codec() {
            return CODEC;
        }
    }

    public static interface PatchCondition {
        public boolean matches(class_1792 var1, class_9335 var2);

        public MapCodec<? extends PatchCondition> codec();
    }
}

