/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.ItemPatches;
import net.atlas.defaulted.mixin.ItemAccessor;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultComponentPatchesManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static List<ItemPatches> CLIENT_CACHED = null;
    private static DefaultComponentPatchesManager INSTANCE;
    private List<ItemPatches> cached = null;
    private Map<ResourceLocation, ItemPatches> intermediary = new HashMap<ResourceLocation, ItemPatches>();

    public DefaultComponentPatchesManager() {
        super(GSON, "defaulted/default_component_patches");
        INSTANCE = this;
    }

    public void patch() {
        Defaulted.patchItemComponents(this.cached);
        Defaulted.EXECUTE_ON_RELOAD.forEach(collectionConsumer -> collectionConsumer.accept(this.cached));
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DefaultComponentPatchesManager.clear();
        return super.prepare(resourceManager, profilerFiller);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, ItemPatches> patchesMap = new HashMap<ResourceLocation, ItemPatches>();
        RegistryOps<JsonElement> registryOps = this.makeOps();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation loc = entry.getKey();
            try {
                Optional optionalItemPatches = (Optional)this.getCodec().parse(registryOps, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                optionalItemPatches.ifPresentOrElse(itemPatches -> patchesMap.put(loc, (ItemPatches)itemPatches), () -> LOGGER.debug("Skipping loading item components patch {} as its conditions were not met", (Object)loc));
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                LOGGER.error("Parsing error loading item patches {}", (Object)loc, (Object)runtimeException);
            }
        }
        this.intermediary = patchesMap;
    }

    public Codec<Optional<ItemPatches>> getCodec() {
        return ItemPatches.DIRECT_CODEC.xmap(Optional::of, Optional::get);
    }

    public abstract RegistryOps<JsonElement> makeOps();

    public static DefaultComponentPatchesManager getInstance() {
        return INSTANCE;
    }

    public static List<ItemPatches> getCached() {
        if (INSTANCE == null) {
            return null;
        }
        INSTANCE.load();
        return DefaultComponentPatchesManager.INSTANCE.cached;
    }

    public void load() {
        if (this.cached == null) {
            this.cached = this.intermediary.entrySet().stream().map(entry -> new ItemPatchesEntry((ResourceLocation)entry.getKey(), (ItemPatches)entry.getValue())).sorted(Comparator.naturalOrder()).map(ItemPatchesEntry::itemPatches).toList();
            this.patch();
        }
    }

    public static void clear() {
        if (INSTANCE != null) {
            DefaultComponentPatchesManager.INSTANCE.cached = null;
        }
        if (CLIENT_CACHED != null) {
            CLIENT_CACHED = null;
        }
    }

    public static void clearClient() {
        DefaultComponentPatchesManager.clear();
        Defaulted.originalComponents.forEach((itemHolder, components) -> ((ItemAccessor)itemHolder.value()).setComponents((DataComponentMap)components));
    }

    public static void loadClientCache(List<ItemPatches> cached) {
        CLIENT_CACHED = cached;
        Defaulted.patchItemComponents(cached);
    }

    public static void setClientCache() {
        CLIENT_CACHED = DefaultComponentPatchesManager.getCached();
    }

    public record ItemPatchesEntry(ResourceLocation id, ItemPatches itemPatches) implements Comparable<ItemPatchesEntry>
    {
        @Override
        public int compareTo(ItemPatchesEntry other) {
            int priority = this.itemPatches.compareTo(other.itemPatches);
            return priority == 0 ? this.id.compareTo(other.id) : priority;
        }
    }
}

