/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.neoforge.event;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Optional;
import net.atlas.defaulted.DefaultComponentPatchesManager;
import net.atlas.defaulted.component.ItemPatches;
import net.atlas.defaulted.networking.ClientboundDefaultComponentsSyncPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class DefaultedNeoForgeEventHandlers {
    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent onDatapackSyncEvent) {
        ClientboundDefaultComponentsSyncPacket packet = new ClientboundDefaultComponentsSyncPacket(new ArrayList<ItemPatches>(DefaultComponentPatchesManager.getCached()));
        onDatapackSyncEvent.getRelevantPlayers().forEach(player -> {
            if (player.connection.hasChannel((CustomPacketPayload)packet)) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    @SubscribeEvent
    public static void onDatapackReload(AddReloadListenerEvent addReloadListenerEvent) {
        addReloadListenerEvent.addListener((PreparableReloadListener)new DefaultComponentPatchesManager(){

            @Override
            public Codec<Optional<ItemPatches>> getCodec() {
                return ConditionalOps.createConditionalCodecWithConditions(ItemPatches.DIRECT_CODEC).xmap(optionalWithConditions -> optionalWithConditions.map(WithConditions::carrier), patches -> patches.map(itemPatches -> WithConditions.builder((Object)itemPatches).build()));
            }

            @Override
            public RegistryOps<JsonElement> makeOps() {
                return this.makeConditionalOps();
            }
        });
    }

    @SubscribeEvent
    public static void serverStart(ServerStartedEvent event) {
        DefaultComponentPatchesManager.getInstance().load();
    }
}

