/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.atlas.defaulted.component.PatchGenerator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;

public record ItemPatches(HolderSet<Item> items, List<TagKey<Item>> tags, List<PatchGenerator> generators, DataComponentPatch dataComponentPatch, int priority) implements Comparable<ItemPatches>
{
    public static final Codec<ItemPatches> DIRECT_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.nonEmptyHolderSet((Codec)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM)).optionalFieldOf("items", (Object)HolderSet.empty()).forGetter(ItemPatches::items), (App)TagKey.codec((ResourceKey)Registries.ITEM).listOf().optionalFieldOf("tags", Collections.emptyList()).forGetter(ItemPatches::tags), (App)PatchGenerator.CODEC.listOf().optionalFieldOf("patch_generators", Collections.emptyList()).forGetter(ItemPatches::generators), (App)DataComponentPatch.CODEC.optionalFieldOf("patch", (Object)DataComponentPatch.EMPTY).forGetter(ItemPatches::dataComponentPatch), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("priority", (Object)1000).forGetter(ItemPatches::priority)).apply((Applicative)instance, ItemPatches::new)));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemPatches> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.ITEM), ItemPatches::items, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)TagKey.streamCodec((ResourceKey)Registries.ITEM)), ItemPatches::tags, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.fromCodecWithRegistriesTrusted(PatchGenerator.CODEC)), ItemPatches::generators, (StreamCodec)DataComponentPatch.STREAM_CODEC, ItemPatches::dataComponentPatch, (StreamCodec)ByteBufCodecs.VAR_INT, ItemPatches::priority, ItemPatches::new);

    @Override
    public int compareTo(ItemPatches o) {
        return this.priority - o.priority;
    }

    public void apply(Item item, PatchedDataComponentMap newMap) {
        if (!this.matchItem(item)) {
            return;
        }
        newMap.applyPatch(this.dataComponentPatch);
    }

    public void applyGenerators(Item item, PatchedDataComponentMap newMap) {
        if (!this.matchItem(item)) {
            return;
        }
        this.generators.forEach(patchGenerator -> patchGenerator.patchDataComponentMap(item, newMap));
    }

    public boolean matchItem(Item item) {
        if (this.items.size() != 0 || !this.tags.isEmpty()) {
            Holder.Reference itemHolder = item.builtInRegistryHolder();
            List<TagKey> matchedTags = this.tags.stream().filter(arg_0 -> ((Holder)itemHolder).is(arg_0)).toList();
            if (!this.items.contains((Holder)itemHolder) && matchedTags.isEmpty()) {
                return false;
            }
        }
        return true;
    }
}

