/*
 * Decompiled with CFR 0.152.
 */
package net.atlas.defaulted.component.generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.function.Function;
import net.atlas.defaulted.Defaulted;
import net.atlas.defaulted.component.PatchGenerator;
import net.atlas.defaulted.component.generators.handler.ArmourVariable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.Equippable;

public record ArmourStatsGenerator(ArmourVariable<Integer> durability, ArmourVariable<Integer> protection, ArmourVariable<Double> armourToughness, ArmourVariable<Double> armourKbRes, boolean persistPrevious) implements PatchGenerator
{
    public static final Codec<Double> POSITIVE_DOUBLE = ArmourStatsGenerator.doubleMiniumumExclusiveWithMessage(0.0, double_ -> "Value must be positive: " + double_);
    public static final MapCodec<ArmourStatsGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ArmourVariable.codec(ExtraCodecs.POSITIVE_INT).optionalFieldOf("max_damage", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::durability), (App)ArmourVariable.codec(ExtraCodecs.POSITIVE_INT).optionalFieldOf("armor", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::protection), (App)ArmourVariable.codec(POSITIVE_DOUBLE).optionalFieldOf("armor_toughness", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::armourToughness), (App)ArmourVariable.codec(POSITIVE_DOUBLE).optionalFieldOf("knockback_resistance", ArmourVariable.empty()).forGetter(ArmourStatsGenerator::armourKbRes), (App)Codec.BOOL.fieldOf("persist_previous").forGetter(ArmourStatsGenerator::persistPrevious)).apply((Applicative)instance, ArmourStatsGenerator::new));

    @Override
    public void patchDataComponentMap(Item item, PatchedDataComponentMap patchedDataComponentMap) {
        Integer maxDamage = this.durability.getValue(item);
        if (maxDamage != null) {
            Defaulted.setDurability(maxDamage, patchedDataComponentMap);
        }
        Integer armor = this.protection.getValue(item);
        Double toughness = this.armourToughness.getValue(item);
        Double kbRes = this.armourKbRes.getValue(item);
        if (armor == null && toughness == null && kbRes == null) {
            return;
        }
        ItemAttributeModifiers oldModifiers = (ItemAttributeModifiers)patchedDataComponentMap.get(DataComponents.ATTRIBUTE_MODIFIERS);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        ArrayList<Holder> addedEntries = new ArrayList<Holder>();
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"armor.any");
        EquipmentSlotGroup slotGroup = EquipmentSlotGroup.ARMOR;
        if (patchedDataComponentMap.has(DataComponents.EQUIPPABLE)) {
            slotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)((Equippable)patchedDataComponentMap.get(DataComponents.EQUIPPABLE)).slot());
        }
        switch (slotGroup) {
            case HEAD: {
                ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"armor.helmet");
                break;
            }
            case CHEST: {
                ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"armor.chestplate");
                break;
            }
            case LEGS: {
                ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"armor.leggings");
                break;
            }
            case FEET: {
                ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"armor.boots");
                break;
            }
            case BODY: {
                ResourceLocation resourceLocation2 = ResourceLocation.withDefaultNamespace((String)"armor.body");
                break;
            }
            default: {
                ResourceLocation resourceLocation2 = resourceLocation = resourceLocation;
            }
        }
        if (armor != null) {
            addedEntries.add(Attributes.ARMOR);
            builder.add(Attributes.ARMOR, new AttributeModifier(resourceLocation, (double)armor.intValue(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
        }
        if (toughness != null) {
            addedEntries.add(Attributes.ARMOR_TOUGHNESS);
            if (toughness > 0.0) {
                builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourceLocation, toughness.doubleValue(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
            }
        }
        if (kbRes != null) {
            addedEntries.add(Attributes.KNOCKBACK_RESISTANCE);
            if (kbRes > 0.0) {
                builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourceLocation, kbRes.doubleValue(), AttributeModifier.Operation.ADD_VALUE), slotGroup);
            }
        }
        if (this.persistPrevious && oldModifiers != null) {
            block7: for (ItemAttributeModifiers.Entry entry : oldModifiers.modifiers()) {
                for (Holder attribute : addedEntries) {
                    if (!entry.matches(attribute, resourceLocation)) continue;
                    continue block7;
                }
                builder.add(entry.attribute(), entry.modifier(), entry.slot());
            }
        }
        patchedDataComponentMap.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)builder.build());
    }

    @Override
    public MapCodec<? extends PatchGenerator> codec() {
        return CODEC;
    }

    public static Codec<Double> doubleMiniumumExclusiveWithMessage(double min, Function<Double, String> function) {
        return Codec.DOUBLE.validate(double_ -> double_.compareTo(min) > 0 ? DataResult.success((Object)double_) : DataResult.error(() -> (String)function.apply((Double)double_)));
    }
}

